/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automaton.transducer;

import java.util.Collection;
import java.util.List;
import net.automatalib.automaton.UniversalDeterministicAutomaton;
import net.automatalib.automaton.concept.DetSuffixOutputAutomaton;
import net.automatalib.automaton.graph.TransitionEdge;
import net.automatalib.automaton.graph.UniversalAutomatonGraphView;
import net.automatalib.automaton.visualization.SSTVisualizationHelper;
import net.automatalib.graph.UniversalGraph;
import net.automatalib.ts.output.DeterministicOutputTS;
import net.automatalib.visualization.VisualizationHelper;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;

public interface SubsequentialTransducer<S, I, T, O>
extends DeterministicOutputTS<S, I, T, O>,
DetSuffixOutputAutomaton<S, I, T, Word<O>>,
UniversalDeterministicAutomaton<S, I, T, Word<O>, Word<O>> {
    @Override
    default public Word<O> computeStateOutput(S state, Iterable<? extends I> input) {
        WordBuilder result = new WordBuilder();
        this.trace(state, input, result);
        return result.toWord();
    }

    @Override
    default public boolean trace(S state, Iterable<? extends I> input, List<? super O> output) {
        S iter = state;
        for (I sym : input) {
            Object trans = this.getTransition(iter, sym);
            if (trans == null) {
                return false;
            }
            Word out = (Word)this.getTransitionProperty(trans);
            if (out != null) {
                output.addAll(out.asList());
            }
            iter = this.getSuccessor(trans);
        }
        if (iter == null) {
            return false;
        }
        Word out = (Word)this.getStateProperty(iter);
        if (out != null) {
            output.addAll(out.asList());
        }
        return true;
    }

    @Override
    default public UniversalGraph<S, TransitionEdge<I, T>, Word<O>, TransitionEdge.Property<I, Word<O>>> transitionGraphView(Collection<? extends I> inputs) {
        return new SSTGraphView(this, inputs);
    }

    public static class SSTGraphView<S, I, T, O, A extends SubsequentialTransducer<S, I, T, O>>
    extends UniversalAutomatonGraphView<S, I, T, Word<O>, Word<O>, A> {
        public SSTGraphView(A automaton, Collection<? extends I> inputs) {
            super(automaton, inputs);
        }

        @Override
        public VisualizationHelper<S, TransitionEdge<I, T>> getVisualizationHelper() {
            return new SSTVisualizationHelper((SubsequentialTransducer)this.automaton);
        }
    }
}

