/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.brics;

import dk.brics.automaton.State;
import dk.brics.automaton.Transition;
import java.util.Collection;
import java.util.Map;
import net.automatalib.brics.AbstractBricsAutomaton;
import net.automatalib.brics.BricsTransitionProperty;
import net.automatalib.visualization.DefaultVisualizationHelper;

final class BricsVisualizationHelper
extends DefaultVisualizationHelper<State, Transition> {
    private final AbstractBricsAutomaton automaton;

    BricsVisualizationHelper(AbstractBricsAutomaton automaton) {
        this.automaton = automaton;
    }

    @Override
    protected Collection<State> initialNodes() {
        return this.automaton.getInitialStates();
    }

    @Override
    public boolean getNodeProperties(State node, Map<String, String> properties) {
        super.getNodeProperties(node, properties);
        String str = node.toString();
        int wsIdx1 = str.indexOf(32);
        int wsIdx2 = str.indexOf(32, wsIdx1 + 1);
        properties.put("label", "s" + str.substring(wsIdx1 + 1, wsIdx2));
        if (node.isAccept()) {
            properties.put("shape", "doublecircle");
        }
        return true;
    }

    @Override
    public boolean getEdgeProperties(State src, Transition edge, State tgt, Map<String, String> properties) {
        super.getEdgeProperties(src, edge, tgt, properties);
        String label = BricsTransitionProperty.toString(edge.getMin(), edge.getMax());
        properties.put("label", label);
        return true;
    }
}

