/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.dfa.dag;

import java.util.ArrayDeque;
import java.util.Iterator;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.incremental.ConflictException;
import net.automatalib.incremental.dfa.Acceptance;
import net.automatalib.incremental.dfa.dag.AbstractIncrementalDFADAGBuilder;
import net.automatalib.incremental.dfa.dag.State;
import net.automatalib.incremental.dfa.dag.StateSignature;
import net.automatalib.incremental.dfa.dag.Transition;
import net.automatalib.word.Word;

public class IncrementalPCDFADAGBuilder<I>
extends AbstractIncrementalDFADAGBuilder<I> {
    public IncrementalPCDFADAGBuilder(Alphabet<I> inputAlphabet) {
        super(inputAlphabet);
    }

    @Override
    public Acceptance lookup(Word<? extends I> word) {
        State s2 = this.getState(word);
        if (s2 == null) {
            return Acceptance.DONT_KNOW;
        }
        return s2 != this.sink ? s2.getAcceptance() : Acceptance.FALSE;
    }

    @Override
    State getState(Word<? extends I> word) {
        if (this.init.getAcceptance() == Acceptance.FALSE) {
            return this.sink;
        }
        State s2 = this.init;
        for (I sym : word) {
            int idx = this.inputAlphabet.getSymbolIndex(sym);
            if ((s2 = s2.getSuccessor(idx)) != null && s2 != this.sink) continue;
            return s2;
        }
        return s2;
    }

    @Override
    public void insert(Word<? extends I> word, boolean accepting) {
        int idx;
        State state;
        Transition next;
        State curr = this.init;
        State conf = null;
        ArrayDeque<Transition> path = new ArrayDeque<Transition>();
        for (I sym : word) {
            int idx2;
            State succ;
            if (curr.getAcceptance() == Acceptance.FALSE) {
                if (accepting) {
                    throw new ConflictException("Conflict");
                }
                return;
            }
            if (conf == null && curr.isConfluence()) {
                conf = curr;
            }
            if ((succ = curr.getSuccessor(idx2 = this.inputAlphabet.getSymbolIndex(sym))) == null) break;
            path.push(new Transition(curr, idx2));
            curr = succ;
        }
        int len = word.length();
        Acceptance acc = Acceptance.fromBoolean(accepting);
        int prefixLen = path.size();
        State last = curr;
        if (prefixLen == len) {
            Acceptance currAcc = curr.getAcceptance();
            if (currAcc == acc) {
                return;
            }
            if (currAcc != Acceptance.DONT_KNOW) {
                throw new ConflictException("Incompatible acceptances: " + (Object)((Object)currAcc) + " vs " + (Object)((Object)acc));
            }
            if (!accepting) {
                if (this.sink == null) {
                    this.sink = State.SINK;
                }
                if (conf == null && !last.isConfluence()) {
                    this.purge(last);
                }
                if (last == this.init) {
                    this.updateInitSignature(Acceptance.FALSE);
                    return;
                }
                last = this.sink;
            } else if (conf != null || last.isConfluence()) {
                last = this.clone(last, Acceptance.TRUE);
            } else {
                if (last == this.init) {
                    this.updateInitSignature(Acceptance.TRUE);
                    return;
                }
                last = this.updateSignature(last, acc);
            }
        } else {
            if (conf != null) {
                if (conf == last) {
                    conf = null;
                }
                last = this.hiddenClone(last);
                if (conf == null) {
                    Transition peek = (Transition)path.peek();
                    assert (peek != null);
                    State prev = peek.state;
                    if (prev != this.init) {
                        this.updateSignature(prev, peek.transIdx, last);
                    } else {
                        this.updateInitSignature(peek.transIdx, last);
                    }
                }
            } else if (last != this.init) {
                this.hide(last);
            }
            Word<I> suffix = word.subWord(prefixLen);
            I sym = suffix.firstSymbol();
            int suffTransIdx = this.inputAlphabet.getSymbolIndex(sym);
            State suffixState = this.createSuffix(suffix.subWord(1), accepting);
            if (last != this.init) {
                last = accepting ? this.unhide(last, Acceptance.TRUE, suffTransIdx, suffixState) : this.unhide(last, suffTransIdx, suffixState);
                if (suffixState.isConfluence()) {
                    Iterator iter = path.descendingIterator();
                    while (iter.hasNext()) {
                        State s2 = ((Transition)iter.next()).state;
                        if (s2 != conf && s2 != suffixState) continue;
                        conf = s2;
                        break;
                    }
                }
            } else if (accepting) {
                this.updateInitSignature(Acceptance.TRUE, suffTransIdx, suffixState);
            } else {
                this.updateInitSignature(suffTransIdx, suffixState);
            }
        }
        if (path.isEmpty()) {
            return;
        }
        if (conf != null) {
            do {
                next = (Transition)path.pop();
                state = next.state;
                idx = next.transIdx;
                state = accepting ? this.clone(state, Acceptance.TRUE, idx, last) : this.clone(state, idx, last);
                last = state;
            } while (next.state != conf);
        }
        while (path.size() > 1) {
            next = (Transition)path.pop();
            state = next.state;
            idx = next.transIdx;
            if (state == last) {
                last = this.clone(state, idx, last);
                continue;
            }
            Acceptance oldAcc = state.getAcceptance();
            State updated = accepting ? this.updateSignature(state, Acceptance.TRUE, idx, last) : this.updateSignature(state, idx, last);
            if (state == updated && oldAcc == updated.getAcceptance()) {
                return;
            }
            last = updated;
        }
        int finalIdx = ((Transition)path.pop()).transIdx;
        if (accepting) {
            this.updateInitSignature(Acceptance.TRUE, finalIdx, last);
        } else {
            this.updateInitSignature(finalIdx, last);
        }
    }

    private void purge(State state) {
        StateSignature sig = state.getSignature();
        if (sig == null) {
            return;
        }
        if (state.getAcceptance() == Acceptance.TRUE) {
            throw new IllegalStateException("Attempting to purge accepting state");
        }
        if (this.register.remove(sig) == null) {
            return;
        }
        sig.acceptance = Acceptance.FALSE;
        for (int i = 0; i < this.alphabetSize; ++i) {
            State succ = ((State[])sig.successors.array)[i];
            if (succ == null) continue;
            if (succ.isConfluence()) {
                succ.decreaseIncoming();
                continue;
            }
            this.purge(succ);
        }
    }

    private State createSuffix(Word<? extends I> suffix, boolean accepting) {
        Acceptance intermediate;
        State last;
        if (!accepting) {
            if (this.sink == null) {
                this.sink = State.SINK;
            }
            last = this.sink;
            intermediate = Acceptance.DONT_KNOW;
        } else {
            StateSignature sig = new StateSignature(this.alphabetSize, Acceptance.TRUE);
            last = this.replaceOrRegister(sig);
            intermediate = Acceptance.TRUE;
        }
        int len = suffix.length();
        for (int i = len - 1; i >= 0; --i) {
            StateSignature sig = new StateSignature(this.alphabetSize, intermediate);
            I sym = suffix.getSymbol(i);
            int idx = this.inputAlphabet.getSymbolIndex(sym);
            ((State[])sig.successors.array)[idx] = last;
            last = this.replaceOrRegister(sig);
        }
        return last;
    }
}

