/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.dot;

import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.automatalib.automaton.AutomatonCreator;
import net.automatalib.automaton.fsa.CompactDFA;
import net.automatalib.automaton.fsa.CompactNFA;
import net.automatalib.automaton.fsa.MutableFSA;
import net.automatalib.automaton.transducer.CompactMealy;
import net.automatalib.automaton.transducer.CompactMoore;
import net.automatalib.automaton.transducer.MutableMealyMachine;
import net.automatalib.automaton.transducer.MutableMooreMachine;
import net.automatalib.common.util.Pair;
import net.automatalib.graph.CompactGraph;
import net.automatalib.graph.MutableGraph;
import net.automatalib.serialization.ModelDeserializer;
import net.automatalib.serialization.dot.DOTGraphParser;
import net.automatalib.serialization.dot.DOTInputModelDeserializer;
import net.automatalib.serialization.dot.DOTMutableAutomatonParser;
import net.automatalib.serialization.dot.GraphDOT;
import net.automatalib.ts.modal.CompactMTS;
import net.automatalib.ts.modal.MutableModalTransitionSystem;
import net.automatalib.ts.modal.transition.ModalEdgeProperty;
import net.automatalib.ts.modal.transition.ModalEdgePropertyImpl;
import net.automatalib.ts.modal.transition.MutableModalEdgeProperty;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class DOTParsers {
    public static final Function<Map<String, String>, @Nullable String> DEFAULT_NODE_PARSER = attr -> (String)attr.get("label");
    public static final Function<Map<String, String>, Boolean> DEFAULT_FSA_NODE_PARSER = attr -> "doublecircle".equals(attr.get("shape"));
    public static final Function<Map<String, String>, @Nullable String> DEFAULT_MOORE_NODE_PARSER = attr -> {
        String label = (String)attr.get("label");
        if (label == null) {
            return null;
        }
        String[] tokens = label.split("/");
        if (tokens.length != 2) {
            return null;
        }
        return tokens[1].trim();
    };
    public static final Function<Map<String, String>, @Nullable String> DEFAULT_EDGE_PARSER = attr -> (String)attr.get("label");
    public static final Function<Map<String, String>, Pair<@Nullable String, @Nullable String>> DEFAULT_MEALY_EDGE_PARSER = attr -> {
        String label = (String)attr.get("label");
        if (label == null) {
            return Pair.of(null, null);
        }
        String[] tokens = label.split("/");
        if (tokens.length != 2) {
            return Pair.of(null, null);
        }
        return Pair.of(tokens[0].trim(), tokens[1].trim());
    };
    public static final Function<Map<String, String>, MutableModalEdgeProperty> DEFAULT_MTS_EDGE_PARSER = attr -> {
        String type = DOTParsers.getAndRequireNotNull(attr, "modality");
        return new ModalEdgePropertyImpl(ModalEdgeProperty.ModalType.valueOf(type.toUpperCase(Locale.ROOT)));
    };

    private DOTParsers() {
    }

    public static DOTInputModelDeserializer<Integer, @Nullable String, CompactDFA<@Nullable String>> dfa() {
        return DOTParsers.dfa(DEFAULT_FSA_NODE_PARSER, DEFAULT_EDGE_PARSER);
    }

    public static <I> DOTInputModelDeserializer<Integer, I, CompactDFA<I>> dfa(Function<Map<String, String>, Boolean> nodeParser, Function<Map<String, String>, I> edgeParser) {
        return DOTParsers.fsa(new CompactDFA.Creator(), nodeParser, edgeParser);
    }

    public static DOTInputModelDeserializer<Integer, @Nullable String, CompactNFA<@Nullable String>> nfa() {
        return DOTParsers.nfa(DEFAULT_FSA_NODE_PARSER, DEFAULT_EDGE_PARSER);
    }

    public static <I> DOTInputModelDeserializer<Integer, I, CompactNFA<I>> nfa(Function<Map<String, String>, Boolean> nodeParser, Function<Map<String, String>, I> edgeParser) {
        return DOTParsers.fsa(new CompactNFA.Creator(), nodeParser, edgeParser);
    }

    public static <S, I, A extends MutableFSA<S, I>> DOTInputModelDeserializer<S, I, A> fsa(AutomatonCreator<A, I> creator, Function<Map<String, String>, Boolean> nodeParser, Function<Map<String, String>, I> edgeParser) {
        return DOTParsers.fsa(creator, nodeParser, edgeParser, Collections.singleton(GraphDOT.initialLabel(0)));
    }

    public static <S, I, A extends MutableFSA<S, I>> DOTInputModelDeserializer<S, I, A> fsa(AutomatonCreator<A, I> creator, Function<Map<String, String>, Boolean> nodeParser, Function<Map<String, String>, I> edgeParser, Collection<String> initialNodeIds) {
        return DOTParsers.fsa(creator, nodeParser, edgeParser, initialNodeIds, true);
    }

    public static <S, I, A extends MutableFSA<S, I>> DOTInputModelDeserializer<S, I, A> fsa(AutomatonCreator<A, I> creator, Function<Map<String, String>, Boolean> nodeParser, Function<Map<String, String>, I> edgeParser, Collection<String> initialNodeIds, boolean fakeInitialNodeIds) {
        return new DOTMutableAutomatonParser(creator, nodeParser, edge -> Pair.of(edgeParser.apply((Map<String, String>)edge), null), initialNodeIds, fakeInitialNodeIds);
    }

    public static DOTInputModelDeserializer<Integer, @Nullable String, CompactMealy<@Nullable String, @Nullable String>> mealy() {
        return DOTParsers.mealy(DEFAULT_MEALY_EDGE_PARSER);
    }

    public static <I, O> DOTInputModelDeserializer<Integer, I, CompactMealy<I, O>> mealy(Function<Map<String, String>, Pair<I, O>> edgeParser) {
        return DOTParsers.mealy(new CompactMealy.Creator(), edgeParser);
    }

    public static <S, I, O, A extends MutableMealyMachine<S, I, ?, O>> DOTInputModelDeserializer<S, I, A> mealy(AutomatonCreator<A, I> creator, Function<Map<String, String>, Pair<I, O>> edgeParser) {
        return DOTParsers.mealy(creator, edgeParser, GraphDOT.initialLabel(0));
    }

    public static <S, I, O, A extends MutableMealyMachine<S, I, ?, O>> DOTInputModelDeserializer<S, I, A> mealy(AutomatonCreator<A, I> creator, Function<Map<String, String>, Pair<I, O>> edgeParser, String initialNodeId) {
        return DOTParsers.mealy(creator, edgeParser, initialNodeId, true);
    }

    public static <S, I, O, A extends MutableMealyMachine<S, I, ?, O>> DOTInputModelDeserializer<S, I, A> mealy(AutomatonCreator<A, I> creator, Function<Map<String, String>, Pair<I, O>> edgeParser, String initialNodeId, boolean fakeInitialNodeId) {
        return new DOTMutableAutomatonParser(creator, node -> null, edgeParser, Collections.singleton(initialNodeId), fakeInitialNodeId);
    }

    public static DOTInputModelDeserializer<Integer, @Nullable String, CompactMoore<@Nullable String, @Nullable String>> moore() {
        return DOTParsers.moore(DEFAULT_MOORE_NODE_PARSER, DEFAULT_EDGE_PARSER);
    }

    public static <I, O> DOTInputModelDeserializer<Integer, I, CompactMoore<I, O>> moore(Function<Map<String, String>, O> nodeParser, Function<Map<String, String>, I> edgeParser) {
        return DOTParsers.moore(new CompactMoore.Creator(), nodeParser, edgeParser);
    }

    public static <S, I, O, A extends MutableMooreMachine<S, I, ?, O>> DOTInputModelDeserializer<S, I, A> moore(AutomatonCreator<A, I> creator, Function<Map<String, String>, O> nodeParser, Function<Map<String, String>, I> edgeParser) {
        return DOTParsers.moore(creator, nodeParser, edgeParser, GraphDOT.initialLabel(0));
    }

    public static <S, I, O, A extends MutableMooreMachine<S, I, ?, O>> DOTInputModelDeserializer<S, I, A> moore(AutomatonCreator<A, I> creator, Function<Map<String, String>, O> nodeParser, Function<Map<String, String>, I> edgeParser, String initialNodeId) {
        return DOTParsers.moore(creator, nodeParser, edgeParser, initialNodeId, true);
    }

    public static <S, I, O, A extends MutableMooreMachine<S, I, ?, O>> DOTInputModelDeserializer<S, I, A> moore(AutomatonCreator<A, I> creator, Function<Map<String, String>, O> nodeParser, Function<Map<String, String>, I> edgeParser, String initialNodeId, boolean fakeInitialNodeId) {
        return new DOTMutableAutomatonParser(creator, nodeParser, edge -> Pair.of(edgeParser.apply((Map<String, String>)edge), null), Collections.singleton(initialNodeId), fakeInitialNodeId);
    }

    public static ModelDeserializer<CompactGraph<@Nullable String, @Nullable String>> graph() {
        return DOTParsers.graph(DEFAULT_NODE_PARSER, DEFAULT_EDGE_PARSER);
    }

    public static <NP, EP> ModelDeserializer<CompactGraph<NP, EP>> graph(Function<Map<String, String>, NP> nodeParser, Function<Map<String, String>, EP> edgeParser) {
        return DOTParsers.graph(CompactGraph::new, nodeParser, edgeParser);
    }

    public static <NP, EP, G extends MutableGraph<?, ?, NP, EP>> ModelDeserializer<G> graph(Supplier<G> creator, Function<Map<String, String>, NP> nodeParser, Function<Map<String, String>, EP> edgeParser) {
        return new DOTGraphParser<NP, EP, G>(creator, nodeParser, edgeParser);
    }

    public static DOTInputModelDeserializer<Integer, @Nullable String, CompactMTS<@Nullable String>> mts() {
        return DOTParsers.mts(CompactMTS::new, DEFAULT_EDGE_PARSER, DEFAULT_MTS_EDGE_PARSER);
    }

    public static <S, I, TP extends MutableModalEdgeProperty, M extends MutableModalTransitionSystem<S, I, ?, TP>> DOTInputModelDeserializer<S, I, M> mts(AutomatonCreator<M, I> creator, Function<Map<String, String>, I> inputParser, Function<Map<String, String>, TP> propertyParser) {
        return DOTParsers.mts(creator, inputParser, propertyParser, Collections.singletonList(GraphDOT.initialLabel(0)));
    }

    public static <S, I, TP extends MutableModalEdgeProperty, M extends MutableModalTransitionSystem<S, I, ?, TP>> DOTInputModelDeserializer<S, I, M> mts(AutomatonCreator<M, I> creator, Function<Map<String, String>, I> inputParser, Function<Map<String, String>, TP> propertyParser, Collection<String> initialNodeIds) {
        return new DOTMutableAutomatonParser(creator, node -> null, edge -> Pair.of(inputParser.apply((Map<String, String>)edge), (MutableModalEdgeProperty)propertyParser.apply((Map<String, String>)edge)), initialNodeIds, true);
    }

    private static String getAndRequireNotNull(Map<String, String> map, String attribute) {
        String value = map.get(attribute);
        if (value == null) {
            throw new IllegalArgumentException("attribute '" + attribute + "' is undefined");
        }
        return value;
    }
}

