/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automaton.procedural;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.automatalib.alphabet.ProceduralInputAlphabet;
import net.automatalib.automaton.fsa.DFA;
import net.automatalib.automaton.procedural.SPA;
import net.automatalib.graph.ContextFreeModalProcessSystem;
import net.automatalib.graph.ProceduralModalProcessGraph;
import net.automatalib.ts.modal.transition.ProceduralModalEdgeProperty;
import net.automatalib.util.automaton.procedural.PMPGEdge;
import org.checkerframework.checker.nullness.qual.Nullable;

class CFMPSViewSPA<I>
implements ContextFreeModalProcessSystem<I, Void> {
    private final SPA<?, I> spa;
    private final Map<I, ProceduralModalProcessGraph<?, I, ?, Void, ?>> pmpgs;

    CFMPSViewSPA(SPA<?, I> spa) {
        this.spa = spa;
        Map procedures = spa.getProcedures();
        this.pmpgs = Maps.newHashMapWithExpectedSize(procedures.size());
        for (Map.Entry e : procedures.entrySet()) {
            this.pmpgs.put(e.getKey(), new MPGView(spa, e.getKey(), (DFA)e.getValue()));
        }
    }

    @Override
    public Map<I, ProceduralModalProcessGraph<?, I, ?, Void, ?>> getPMPGs() {
        return this.pmpgs;
    }

    @Override
    public @Nullable I getMainProcess() {
        return this.spa.getInitialProcedure();
    }

    private static class MPGView<S, I>
    implements ProceduralModalProcessGraph<S, I, PMPGEdge<I, S>, Void, ProceduralModalEdgeProperty> {
        private static final Object INITIAL = new Object();
        private static final Object FINAL = new Object();
        private final ProceduralInputAlphabet<I> alphabet;
        private final Collection<I> proceduralInputs;
        private final I procedure;
        private final DFA<S, I> dfa;
        private final S dfaInit;
        private final S initialNode;
        private final S finalNode;

        MPGView(SPA<?, I> spa, I procedure, DFA<S, I> dfa) {
            Object dfaInit = dfa.getInitialState();
            if (dfaInit == null) {
                throw new IllegalArgumentException("Empty DFAs cannot be mapped to ModalProcessGraphs");
            }
            this.alphabet = spa.getInputAlphabet();
            this.proceduralInputs = spa.getProceduralInputs();
            this.procedure = procedure;
            this.dfa = dfa;
            this.dfaInit = dfaInit;
            this.initialNode = INITIAL;
            this.finalNode = FINAL;
        }

        @Override
        public Collection<PMPGEdge<I, S>> getOutgoingEdges(S node) {
            ArrayList<PMPGEdge<I, S>> result;
            if (node == this.initialNode) {
                return Collections.singletonList(new PMPGEdge<I, S>(this.procedure, this.dfaInit, ProceduralModalEdgeProperty.ProceduralType.INTERNAL));
            }
            if (node == this.finalNode) {
                return Collections.emptyList();
            }
            if (this.dfa.isAccepting(node)) {
                result = new ArrayList(this.proceduralInputs.size() + 1);
                result.add(new PMPGEdge<I, S>(this.alphabet.getReturnSymbol(), this.getFinalNode(), ProceduralModalEdgeProperty.ProceduralType.INTERNAL));
            } else {
                result = new ArrayList<PMPGEdge<I, S>>(this.proceduralInputs.size());
            }
            for (I i : this.proceduralInputs) {
                ProceduralModalEdgeProperty.ProceduralType type;
                S succ = this.dfa.getSuccessor(node, i);
                if (succ == null) continue;
                if (this.alphabet.isCallSymbol(i)) {
                    type = ProceduralModalEdgeProperty.ProceduralType.PROCESS;
                } else if (this.alphabet.isInternalSymbol(i)) {
                    type = ProceduralModalEdgeProperty.ProceduralType.INTERNAL;
                } else {
                    throw new IllegalStateException("Unexpected symbol type");
                }
                result.add(new PMPGEdge<I, S>(i, succ, type));
            }
            return result;
        }

        @Override
        public S getTarget(PMPGEdge<I, S> edge) {
            return edge.succ;
        }

        @Override
        public Collection<S> getNodes() {
            ArrayList nodes = new ArrayList(this.dfa.size() + 2);
            nodes.add(this.initialNode);
            nodes.add(this.finalNode);
            nodes.addAll(this.dfa.getStates());
            return nodes;
        }

        @Override
        public Set<Void> getNodeProperty(S node) {
            return Collections.emptySet();
        }

        @Override
        public ProceduralModalEdgeProperty getEdgeProperty(PMPGEdge<I, S> edge) {
            return edge;
        }

        @Override
        public I getEdgeLabel(PMPGEdge<I, S> edge) {
            return edge.input;
        }

        @Override
        public S getFinalNode() {
            return this.finalNode;
        }

        @Override
        public S getInitialNode() {
            return this.initialNode;
        }
    }
}

