/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.automatalib.common.util.mapping.Mapping;
import net.automatalib.common.util.mapping.MutableMapping;
import net.automatalib.graph.BidirectionalGraph;
import net.automatalib.graph.Graph;
import net.automatalib.graph.concept.EdgeWeights;
import net.automatalib.util.graph.apsp.APSPResult;
import net.automatalib.util.graph.apsp.FloydWarshallAPSP;
import net.automatalib.util.graph.scc.SCCListener;
import net.automatalib.util.graph.scc.SCCs;
import net.automatalib.util.graph.sssp.DijkstraSSSP;
import net.automatalib.util.graph.sssp.SSSPResult;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Graphs {
    public static final float INVALID_DISTANCE = Float.NEGATIVE_INFINITY;

    private Graphs() {
    }

    public static <N, E> Mapping<N, @Nullable Collection<E>> incomingEdges(Graph<N, E> graph) {
        if (graph instanceof BidirectionalGraph) {
            BidirectionalGraph bdGraph = (BidirectionalGraph)graph;
            return bdGraph::getIncomingEdges;
        }
        MutableMapping<N, @Nullable V> inEdgesMapping = graph.createStaticNodeMapping();
        for (Object node : graph) {
            Collection<E> outEdges = graph.getOutgoingEdges(node);
            for (E e : outEdges) {
                Object tgt = graph.getTarget(e);
                ArrayList<E> inEdges = (ArrayList<E>)inEdgesMapping.get(tgt);
                if (inEdges == null) {
                    inEdges = new ArrayList<E>();
                    inEdgesMapping.put(tgt, inEdges);
                }
                inEdges.add(e);
            }
        }
        return inEdgesMapping;
    }

    public static <N, E> List<N> toNodeList(List<E> edgeList, Graph<N, E> graph, N init) {
        ArrayList result = new ArrayList(edgeList.size() + 1);
        result.add(init);
        for (E edge : edgeList) {
            Object tgt = graph.getTarget(edge);
            result.add(tgt);
        }
        return result;
    }

    public static <N, E> APSPResult<N, E> findAPSP(Graph<N, E> graph, EdgeWeights<E> edgeWeights) {
        return FloydWarshallAPSP.findAPSP(graph, edgeWeights);
    }

    public static <N, E> SSSPResult<N, E> findSSSP(Graph<N, E> graph, N init, EdgeWeights<E> edgeWeights) {
        return DijkstraSSSP.findSSSP(graph, init, edgeWeights);
    }

    public static <N, E> List<List<N>> collectSCCs(Graph<N, E> graph) {
        return SCCs.collectSCCs(graph);
    }

    public static <N, E> void findSCCs(Graph<N, E> graph, SCCListener<N> sccListener) {
        SCCs.findSCCs(graph, sccListener);
    }
}

