/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.block;

import org.ejml.data.DMatrixRBlock;
import org.ejml.data.DSubmatrixD1;
import org.ejml.dense.block.MatrixMult_MT_DDRB;

public class MatrixOps_MT_DDRB {
    public static void mult(DMatrixRBlock A2, DMatrixRBlock B, DMatrixRBlock C2) {
        if (A2.numCols != B.numRows) {
            throw new IllegalArgumentException("Columns in A are incompatible with rows in B");
        }
        if (A2.numRows != C2.numRows) {
            throw new IllegalArgumentException("Rows in A are incompatible with rows in C");
        }
        if (B.numCols != C2.numCols) {
            throw new IllegalArgumentException("Columns in B are incompatible with columns in C");
        }
        if (A2.blockLength != B.blockLength || A2.blockLength != C2.blockLength) {
            throw new IllegalArgumentException("Block lengths are not all the same.");
        }
        int blockLength = A2.blockLength;
        DSubmatrixD1 Asub = new DSubmatrixD1(A2, 0, A2.numRows, 0, A2.numCols);
        DSubmatrixD1 Bsub = new DSubmatrixD1(B, 0, B.numRows, 0, B.numCols);
        DSubmatrixD1 Csub = new DSubmatrixD1(C2, 0, C2.numRows, 0, C2.numCols);
        MatrixMult_MT_DDRB.mult(blockLength, Asub, Bsub, Csub);
    }

    public static void multTransA(DMatrixRBlock A2, DMatrixRBlock B, DMatrixRBlock C2) {
        if (A2.numRows != B.numRows) {
            throw new IllegalArgumentException("Rows in A are incompatible with rows in B");
        }
        if (A2.numCols != C2.numRows) {
            throw new IllegalArgumentException("Columns in A are incompatible with rows in C");
        }
        if (B.numCols != C2.numCols) {
            throw new IllegalArgumentException("Columns in B are incompatible with columns in C");
        }
        if (A2.blockLength != B.blockLength || A2.blockLength != C2.blockLength) {
            throw new IllegalArgumentException("Block lengths are not all the same.");
        }
        int blockLength = A2.blockLength;
        DSubmatrixD1 Asub = new DSubmatrixD1(A2, 0, A2.numRows, 0, A2.numCols);
        DSubmatrixD1 Bsub = new DSubmatrixD1(B, 0, B.numRows, 0, B.numCols);
        DSubmatrixD1 Csub = new DSubmatrixD1(C2, 0, C2.numRows, 0, C2.numCols);
        MatrixMult_MT_DDRB.multTransA(blockLength, Asub, Bsub, Csub);
    }

    public static void multTransB(DMatrixRBlock A2, DMatrixRBlock B, DMatrixRBlock C2) {
        if (A2.numCols != B.numCols) {
            throw new IllegalArgumentException("Columns in A are incompatible with columns in B");
        }
        if (A2.numRows != C2.numRows) {
            throw new IllegalArgumentException("Rows in A are incompatible with rows in C");
        }
        if (B.numRows != C2.numCols) {
            throw new IllegalArgumentException("Rows in B are incompatible with columns in C");
        }
        if (A2.blockLength != B.blockLength || A2.blockLength != C2.blockLength) {
            throw new IllegalArgumentException("Block lengths are not all the same.");
        }
        int blockLength = A2.blockLength;
        DSubmatrixD1 Asub = new DSubmatrixD1(A2, 0, A2.numRows, 0, A2.numCols);
        DSubmatrixD1 Bsub = new DSubmatrixD1(B, 0, B.numRows, 0, B.numCols);
        DSubmatrixD1 Csub = new DSubmatrixD1(C2, 0, C2.numRows, 0, C2.numCols);
        MatrixMult_MT_DDRB.multTransB(blockLength, Asub, Bsub, Csub);
    }
}

