/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row.mult;

import org.ejml.UtilEjml;
import org.ejml.concurrency.EjmlConcurrency;
import org.ejml.data.DMatrix1Row;
import org.ejml.dense.row.CommonOps_DDRM;

public class MatrixMatrixMult_MT_DDRM {
    public static void mult_reorder(DMatrix1Row A2, DMatrix1Row B, DMatrix1Row C2) {
        UtilEjml.assertTrue(A2 != C2 && B != C2, "Neither 'A' or 'B' can be the same matrix as 'C'");
        UtilEjml.assertShape(A2.numCols, B.numRows, "The 'A' and 'B' matrices do not have compatible dimensions");
        C2.reshape(A2.numRows, B.numCols);
        if (A2.numCols == 0 || A2.numRows == 0) {
            CommonOps_DDRM.fill(C2, 0.0);
            return;
        }
        int endOfKLoop = B.numRows * B.numCols;
        EjmlConcurrency.loopFor(0, A2.numRows, i -> {
            int indexCbase = i * C2.numCols;
            int indexA = i * A2.numCols;
            int indexB = 0;
            int indexC = indexCbase;
            int end = indexB + B.numCols;
            double valA = A2.data[indexA++];
            while (indexB < end) {
                C2.set(indexC++, valA * B.data[indexB++]);
            }
            while (indexB != endOfKLoop) {
                indexC = indexCbase;
                end = indexB + B.numCols;
                valA = A2.data[indexA++];
                while (indexB < end) {
                    int n = indexC++;
                    C2.data[n] = C2.data[n] + valA * B.data[indexB++];
                }
            }
        });
    }

    public static void mult_small(DMatrix1Row A2, DMatrix1Row B, DMatrix1Row C2) {
        UtilEjml.assertTrue(A2 != C2 && B != C2, "Neither 'A' or 'B' can be the same matrix as 'C'");
        UtilEjml.assertShape(A2.numCols, B.numRows, "The 'A' and 'B' matrices do not have compatible dimensions");
        C2.reshape(A2.numRows, B.numCols);
        EjmlConcurrency.loopFor(0, A2.numRows, i -> {
            int cIndex = i * B.numCols;
            int aIndexStart = i * A2.numCols;
            for (int j = 0; j < B.numCols; ++j) {
                double total = 0.0;
                int indexA = aIndexStart;
                int indexB = j;
                int end = indexA + B.numRows;
                while (indexA < end) {
                    total += A2.data[indexA++] * B.data[indexB];
                    indexB += B.numCols;
                }
                C2.set(cIndex++, total);
            }
        });
    }

    public static void multTransA_reorder(DMatrix1Row A2, DMatrix1Row B, DMatrix1Row C2) {
        UtilEjml.assertTrue(A2 != C2 && B != C2, "Neither 'A' or 'B' can be the same matrix as 'C'");
        UtilEjml.assertShape(A2.numRows, B.numRows, "The 'A' and 'B' matrices do not have compatible dimensions");
        C2.reshape(A2.numCols, B.numCols);
        if (A2.numCols == 0 || A2.numRows == 0) {
            CommonOps_DDRM.fill(C2, 0.0);
            return;
        }
        EjmlConcurrency.loopFor(0, A2.numRows, i -> {
            int indexC_start = i * C2.numCols;
            double valA = A2.data[i];
            int indexB = 0;
            int end = indexB + B.numCols;
            int indexC = indexC_start;
            while (indexB < end) {
                C2.set(indexC++, valA * B.data[indexB++]);
            }
            for (int k = 1; k < A2.numRows; ++k) {
                valA = A2.unsafe_get(k, i);
                end = indexB + B.numCols;
                indexC = indexC_start;
                while (indexB < end) {
                    int n = indexC++;
                    C2.data[n] = C2.data[n] + valA * B.data[indexB++];
                }
            }
        });
    }

    public static void multTransA_small(DMatrix1Row A2, DMatrix1Row B, DMatrix1Row C2) {
        UtilEjml.assertTrue(A2 != C2 && B != C2, "Neither 'A' or 'B' can be the same matrix as 'C'");
        UtilEjml.assertShape(A2.numRows, B.numRows, "The 'A' and 'B' matrices do not have compatible dimensions");
        C2.reshape(A2.numCols, B.numCols);
        EjmlConcurrency.loopFor(0, A2.numCols, i -> {
            int cIndex = i * B.numCols;
            for (int j = 0; j < B.numCols; ++j) {
                int indexB;
                int indexA = i;
                int end = indexB + B.numRows * B.numCols;
                double total = 0.0;
                for (indexB = j; indexB < end; indexB += B.numCols) {
                    total += A2.data[indexA] * B.data[indexB];
                    indexA += A2.numCols;
                }
                C2.set(cIndex++, total);
            }
        });
    }

    public static void multTransAB(DMatrix1Row A2, DMatrix1Row B, DMatrix1Row C2) {
        UtilEjml.assertTrue(A2 != C2 && B != C2, "Neither 'A' or 'B' can be the same matrix as 'C'");
        UtilEjml.assertShape(A2.numRows, B.numCols, "The 'A' and 'B' matrices do not have compatible dimensions");
        C2.reshape(A2.numCols, B.numRows);
        EjmlConcurrency.loopFor(0, A2.numCols, i -> {
            int cIndex = i * B.numRows;
            int indexB = 0;
            for (int j = 0; j < B.numRows; ++j) {
                int indexA = i;
                int end = indexB + B.numCols;
                double total = 0.0;
                while (indexB < end) {
                    total += A2.data[indexA] * B.data[indexB++];
                    indexA += A2.numCols;
                }
                C2.set(cIndex++, total);
            }
        });
    }

    public static void multTransB(DMatrix1Row A2, DMatrix1Row B, DMatrix1Row C2) {
        UtilEjml.assertTrue(A2 != C2 && B != C2, "Neither 'A' or 'B' can be the same matrix as 'C'");
        UtilEjml.assertShape(A2.numCols, B.numCols, "The 'A' and 'B' matrices do not have compatible dimensions");
        C2.reshape(A2.numRows, B.numRows);
        EjmlConcurrency.loopFor(0, A2.numRows, xA -> {
            int cIndex = xA * B.numRows;
            int aIndexStart = xA * B.numCols;
            int end = aIndexStart + B.numCols;
            int indexB = 0;
            for (int xB = 0; xB < B.numRows; ++xB) {
                int indexA = aIndexStart;
                double total = 0.0;
                while (indexA < end) {
                    total += A2.data[indexA++] * B.data[indexB++];
                }
                C2.set(cIndex++, total);
            }
        });
    }

    public static void multAdd_reorder(DMatrix1Row A2, DMatrix1Row B, DMatrix1Row C2) {
        UtilEjml.assertTrue(A2 != C2 && B != C2, "Neither 'A' or 'B' can be the same matrix as 'C'");
        UtilEjml.assertShape(A2.numCols, B.numRows, "The 'A' and 'B' matrices do not have compatible dimensions");
        UtilEjml.assertShape(A2.numRows == C2.numRows && B.numCols == C2.numCols, "C is not compatible with A and B");
        if (A2.numCols == 0 || A2.numRows == 0) {
            return;
        }
        int endOfKLoop = B.numRows * B.numCols;
        EjmlConcurrency.loopFor(0, A2.numRows, i -> {
            int indexCbase = i * C2.numCols;
            int indexA = i * A2.numCols;
            int indexB = 0;
            int indexC = indexCbase;
            int end = indexB + B.numCols;
            double valA = A2.data[indexA++];
            while (indexB < end) {
                C2.plus(indexC++, valA * B.data[indexB++]);
            }
            while (indexB != endOfKLoop) {
                indexC = indexCbase;
                end = indexB + B.numCols;
                valA = A2.data[indexA++];
                while (indexB < end) {
                    int n = indexC++;
                    C2.data[n] = C2.data[n] + valA * B.data[indexB++];
                }
            }
        });
    }

    public static void multAdd_small(DMatrix1Row A2, DMatrix1Row B, DMatrix1Row C2) {
        UtilEjml.assertTrue(A2 != C2 && B != C2, "Neither 'A' or 'B' can be the same matrix as 'C'");
        UtilEjml.assertShape(A2.numCols, B.numRows, "The 'A' and 'B' matrices do not have compatible dimensions");
        UtilEjml.assertShape(A2.numRows == C2.numRows && B.numCols == C2.numCols, "C is not compatible with A and B");
        EjmlConcurrency.loopFor(0, A2.numRows, i -> {
            int cIndex = i * B.numCols;
            int aIndexStart = i * A2.numCols;
            for (int j = 0; j < B.numCols; ++j) {
                double total = 0.0;
                int indexA = aIndexStart;
                int indexB = j;
                int end = indexA + B.numRows;
                while (indexA < end) {
                    total += A2.data[indexA++] * B.data[indexB];
                    indexB += B.numCols;
                }
                C2.plus(cIndex++, total);
            }
        });
    }

    public static void multAddTransA_reorder(DMatrix1Row A2, DMatrix1Row B, DMatrix1Row C2) {
        UtilEjml.assertTrue(A2 != C2 && B != C2, "Neither 'A' or 'B' can be the same matrix as 'C'");
        UtilEjml.assertShape(A2.numRows, B.numRows, "The 'A' and 'B' matrices do not have compatible dimensions");
        UtilEjml.assertShape(A2.numCols == C2.numRows && B.numCols == C2.numCols, "C is not compatible with A and B");
        if (A2.numCols == 0 || A2.numRows == 0) {
            return;
        }
        EjmlConcurrency.loopFor(0, A2.numRows, i -> {
            int indexC_start = i * C2.numCols;
            double valA = A2.data[i];
            int indexB = 0;
            int end = indexB + B.numCols;
            int indexC = indexC_start;
            while (indexB < end) {
                C2.plus(indexC++, valA * B.data[indexB++]);
            }
            for (int k = 1; k < A2.numRows; ++k) {
                valA = A2.unsafe_get(k, i);
                end = indexB + B.numCols;
                indexC = indexC_start;
                while (indexB < end) {
                    int n = indexC++;
                    C2.data[n] = C2.data[n] + valA * B.data[indexB++];
                }
            }
        });
    }

    public static void multAddTransA_small(DMatrix1Row A2, DMatrix1Row B, DMatrix1Row C2) {
        UtilEjml.assertTrue(A2 != C2 && B != C2, "Neither 'A' or 'B' can be the same matrix as 'C'");
        UtilEjml.assertShape(A2.numRows, B.numRows, "The 'A' and 'B' matrices do not have compatible dimensions");
        UtilEjml.assertShape(A2.numCols == C2.numRows && B.numCols == C2.numCols, "C is not compatible with A and B");
        EjmlConcurrency.loopFor(0, A2.numCols, i -> {
            int cIndex = i * B.numCols;
            for (int j = 0; j < B.numCols; ++j) {
                int indexB;
                int indexA = i;
                int end = indexB + B.numRows * B.numCols;
                double total = 0.0;
                for (indexB = j; indexB < end; indexB += B.numCols) {
                    total += A2.data[indexA] * B.data[indexB];
                    indexA += A2.numCols;
                }
                C2.plus(cIndex++, total);
            }
        });
    }

    public static void multAddTransAB(DMatrix1Row A2, DMatrix1Row B, DMatrix1Row C2) {
        UtilEjml.assertTrue(A2 != C2 && B != C2, "Neither 'A' or 'B' can be the same matrix as 'C'");
        UtilEjml.assertShape(A2.numRows, B.numCols, "The 'A' and 'B' matrices do not have compatible dimensions");
        UtilEjml.assertShape(A2.numCols == C2.numRows && B.numRows == C2.numCols, "C is not compatible with A and B");
        EjmlConcurrency.loopFor(0, A2.numCols, i -> {
            int cIndex = i * B.numRows;
            int indexB = 0;
            for (int j = 0; j < B.numRows; ++j) {
                int indexA = i;
                int end = indexB + B.numCols;
                double total = 0.0;
                while (indexB < end) {
                    total += A2.data[indexA] * B.data[indexB++];
                    indexA += A2.numCols;
                }
                C2.plus(cIndex++, total);
            }
        });
    }

    public static void multAddTransB(DMatrix1Row A2, DMatrix1Row B, DMatrix1Row C2) {
        UtilEjml.assertTrue(A2 != C2 && B != C2, "Neither 'A' or 'B' can be the same matrix as 'C'");
        UtilEjml.assertShape(A2.numCols, B.numCols, "The 'A' and 'B' matrices do not have compatible dimensions");
        UtilEjml.assertShape(A2.numRows == C2.numRows && B.numRows == C2.numCols, "C is not compatible with A and B");
        EjmlConcurrency.loopFor(0, A2.numRows, xA -> {
            int cIndex = xA * B.numRows;
            int aIndexStart = xA * B.numCols;
            int end = aIndexStart + B.numCols;
            int indexB = 0;
            for (int xB = 0; xB < B.numRows; ++xB) {
                int indexA = aIndexStart;
                double total = 0.0;
                while (indexA < end) {
                    total += A2.data[indexA++] * B.data[indexB++];
                }
                C2.plus(cIndex++, total);
            }
        });
    }

    public static void mult_reorder(double alpha, DMatrix1Row A2, DMatrix1Row B, DMatrix1Row C2) {
        UtilEjml.assertTrue(A2 != C2 && B != C2, "Neither 'A' or 'B' can be the same matrix as 'C'");
        UtilEjml.assertShape(A2.numCols, B.numRows, "The 'A' and 'B' matrices do not have compatible dimensions");
        C2.reshape(A2.numRows, B.numCols);
        if (A2.numCols == 0 || A2.numRows == 0) {
            CommonOps_DDRM.fill(C2, 0.0);
            return;
        }
        int endOfKLoop = B.numRows * B.numCols;
        EjmlConcurrency.loopFor(0, A2.numRows, i -> {
            int indexCbase = i * C2.numCols;
            int indexA = i * A2.numCols;
            int indexB = 0;
            int indexC = indexCbase;
            int end = indexB + B.numCols;
            double valA = alpha * A2.data[indexA++];
            while (indexB < end) {
                C2.set(indexC++, valA * B.data[indexB++]);
            }
            while (indexB != endOfKLoop) {
                indexC = indexCbase;
                end = indexB + B.numCols;
                valA = alpha * A2.data[indexA++];
                while (indexB < end) {
                    int n = indexC++;
                    C2.data[n] = C2.data[n] + valA * B.data[indexB++];
                }
            }
        });
    }

    public static void mult_small(double alpha, DMatrix1Row A2, DMatrix1Row B, DMatrix1Row C2) {
        UtilEjml.assertTrue(A2 != C2 && B != C2, "Neither 'A' or 'B' can be the same matrix as 'C'");
        UtilEjml.assertShape(A2.numCols, B.numRows, "The 'A' and 'B' matrices do not have compatible dimensions");
        C2.reshape(A2.numRows, B.numCols);
        EjmlConcurrency.loopFor(0, A2.numRows, i -> {
            int cIndex = i * B.numCols;
            int aIndexStart = i * A2.numCols;
            for (int j = 0; j < B.numCols; ++j) {
                double total = 0.0;
                int indexA = aIndexStart;
                int indexB = j;
                int end = indexA + B.numRows;
                while (indexA < end) {
                    total += A2.data[indexA++] * B.data[indexB];
                    indexB += B.numCols;
                }
                C2.set(cIndex++, alpha * total);
            }
        });
    }

    public static void multTransA_reorder(double alpha, DMatrix1Row A2, DMatrix1Row B, DMatrix1Row C2) {
        UtilEjml.assertTrue(A2 != C2 && B != C2, "Neither 'A' or 'B' can be the same matrix as 'C'");
        UtilEjml.assertShape(A2.numRows, B.numRows, "The 'A' and 'B' matrices do not have compatible dimensions");
        C2.reshape(A2.numCols, B.numCols);
        if (A2.numCols == 0 || A2.numRows == 0) {
            CommonOps_DDRM.fill(C2, 0.0);
            return;
        }
        EjmlConcurrency.loopFor(0, A2.numRows, i -> {
            int indexC_start = i * C2.numCols;
            double valA = alpha * A2.data[i];
            int indexB = 0;
            int end = indexB + B.numCols;
            int indexC = indexC_start;
            while (indexB < end) {
                C2.set(indexC++, valA * B.data[indexB++]);
            }
            for (int k = 1; k < A2.numRows; ++k) {
                valA = alpha * A2.unsafe_get(k, i);
                end = indexB + B.numCols;
                indexC = indexC_start;
                while (indexB < end) {
                    int n = indexC++;
                    C2.data[n] = C2.data[n] + valA * B.data[indexB++];
                }
            }
        });
    }

    public static void multTransA_small(double alpha, DMatrix1Row A2, DMatrix1Row B, DMatrix1Row C2) {
        UtilEjml.assertTrue(A2 != C2 && B != C2, "Neither 'A' or 'B' can be the same matrix as 'C'");
        UtilEjml.assertShape(A2.numRows, B.numRows, "The 'A' and 'B' matrices do not have compatible dimensions");
        C2.reshape(A2.numCols, B.numCols);
        EjmlConcurrency.loopFor(0, A2.numCols, i -> {
            int cIndex = i * B.numCols;
            for (int j = 0; j < B.numCols; ++j) {
                int indexB;
                int indexA = i;
                int end = indexB + B.numRows * B.numCols;
                double total = 0.0;
                for (indexB = j; indexB < end; indexB += B.numCols) {
                    total += A2.data[indexA] * B.data[indexB];
                    indexA += A2.numCols;
                }
                C2.set(cIndex++, alpha * total);
            }
        });
    }

    public static void multTransAB(double alpha, DMatrix1Row A2, DMatrix1Row B, DMatrix1Row C2) {
        UtilEjml.assertTrue(A2 != C2 && B != C2, "Neither 'A' or 'B' can be the same matrix as 'C'");
        UtilEjml.assertShape(A2.numRows, B.numCols, "The 'A' and 'B' matrices do not have compatible dimensions");
        C2.reshape(A2.numCols, B.numRows);
        EjmlConcurrency.loopFor(0, A2.numCols, i -> {
            int cIndex = i * B.numRows;
            int indexB = 0;
            for (int j = 0; j < B.numRows; ++j) {
                int indexA = i;
                int end = indexB + B.numCols;
                double total = 0.0;
                while (indexB < end) {
                    total += A2.data[indexA] * B.data[indexB++];
                    indexA += A2.numCols;
                }
                C2.set(cIndex++, alpha * total);
            }
        });
    }

    public static void multTransB(double alpha, DMatrix1Row A2, DMatrix1Row B, DMatrix1Row C2) {
        UtilEjml.assertTrue(A2 != C2 && B != C2, "Neither 'A' or 'B' can be the same matrix as 'C'");
        UtilEjml.assertShape(A2.numCols, B.numCols, "The 'A' and 'B' matrices do not have compatible dimensions");
        C2.reshape(A2.numRows, B.numRows);
        EjmlConcurrency.loopFor(0, A2.numRows, xA -> {
            int cIndex = xA * B.numRows;
            int aIndexStart = xA * B.numCols;
            int end = aIndexStart + B.numCols;
            int indexB = 0;
            for (int xB = 0; xB < B.numRows; ++xB) {
                int indexA = aIndexStart;
                double total = 0.0;
                while (indexA < end) {
                    total += A2.data[indexA++] * B.data[indexB++];
                }
                C2.set(cIndex++, alpha * total);
            }
        });
    }

    public static void multAdd_reorder(double alpha, DMatrix1Row A2, DMatrix1Row B, DMatrix1Row C2) {
        UtilEjml.assertTrue(A2 != C2 && B != C2, "Neither 'A' or 'B' can be the same matrix as 'C'");
        UtilEjml.assertShape(A2.numCols, B.numRows, "The 'A' and 'B' matrices do not have compatible dimensions");
        UtilEjml.assertShape(A2.numRows == C2.numRows && B.numCols == C2.numCols, "C is not compatible with A and B");
        if (A2.numCols == 0 || A2.numRows == 0) {
            return;
        }
        int endOfKLoop = B.numRows * B.numCols;
        EjmlConcurrency.loopFor(0, A2.numRows, i -> {
            int indexCbase = i * C2.numCols;
            int indexA = i * A2.numCols;
            int indexB = 0;
            int indexC = indexCbase;
            int end = indexB + B.numCols;
            double valA = alpha * A2.data[indexA++];
            while (indexB < end) {
                C2.plus(indexC++, valA * B.data[indexB++]);
            }
            while (indexB != endOfKLoop) {
                indexC = indexCbase;
                end = indexB + B.numCols;
                valA = alpha * A2.data[indexA++];
                while (indexB < end) {
                    int n = indexC++;
                    C2.data[n] = C2.data[n] + valA * B.data[indexB++];
                }
            }
        });
    }

    public static void multAdd_small(double alpha, DMatrix1Row A2, DMatrix1Row B, DMatrix1Row C2) {
        UtilEjml.assertTrue(A2 != C2 && B != C2, "Neither 'A' or 'B' can be the same matrix as 'C'");
        UtilEjml.assertShape(A2.numCols, B.numRows, "The 'A' and 'B' matrices do not have compatible dimensions");
        UtilEjml.assertShape(A2.numRows == C2.numRows && B.numCols == C2.numCols, "C is not compatible with A and B");
        EjmlConcurrency.loopFor(0, A2.numRows, i -> {
            int cIndex = i * B.numCols;
            int aIndexStart = i * A2.numCols;
            for (int j = 0; j < B.numCols; ++j) {
                double total = 0.0;
                int indexA = aIndexStart;
                int indexB = j;
                int end = indexA + B.numRows;
                while (indexA < end) {
                    total += A2.data[indexA++] * B.data[indexB];
                    indexB += B.numCols;
                }
                C2.plus(cIndex++, alpha * total);
            }
        });
    }

    public static void multAddTransA_reorder(double alpha, DMatrix1Row A2, DMatrix1Row B, DMatrix1Row C2) {
        UtilEjml.assertTrue(A2 != C2 && B != C2, "Neither 'A' or 'B' can be the same matrix as 'C'");
        UtilEjml.assertShape(A2.numRows, B.numRows, "The 'A' and 'B' matrices do not have compatible dimensions");
        UtilEjml.assertShape(A2.numCols == C2.numRows && B.numCols == C2.numCols, "C is not compatible with A and B");
        if (A2.numCols == 0 || A2.numRows == 0) {
            return;
        }
        EjmlConcurrency.loopFor(0, A2.numRows, i -> {
            int indexC_start = i * C2.numCols;
            double valA = alpha * A2.data[i];
            int indexB = 0;
            int end = indexB + B.numCols;
            int indexC = indexC_start;
            while (indexB < end) {
                C2.plus(indexC++, valA * B.data[indexB++]);
            }
            for (int k = 1; k < A2.numRows; ++k) {
                valA = alpha * A2.unsafe_get(k, i);
                end = indexB + B.numCols;
                indexC = indexC_start;
                while (indexB < end) {
                    int n = indexC++;
                    C2.data[n] = C2.data[n] + valA * B.data[indexB++];
                }
            }
        });
    }

    public static void multAddTransA_small(double alpha, DMatrix1Row A2, DMatrix1Row B, DMatrix1Row C2) {
        UtilEjml.assertTrue(A2 != C2 && B != C2, "Neither 'A' or 'B' can be the same matrix as 'C'");
        UtilEjml.assertShape(A2.numRows, B.numRows, "The 'A' and 'B' matrices do not have compatible dimensions");
        UtilEjml.assertShape(A2.numCols == C2.numRows && B.numCols == C2.numCols, "C is not compatible with A and B");
        EjmlConcurrency.loopFor(0, A2.numCols, i -> {
            int cIndex = i * B.numCols;
            for (int j = 0; j < B.numCols; ++j) {
                int indexB;
                int indexA = i;
                int end = indexB + B.numRows * B.numCols;
                double total = 0.0;
                for (indexB = j; indexB < end; indexB += B.numCols) {
                    total += A2.data[indexA] * B.data[indexB];
                    indexA += A2.numCols;
                }
                C2.plus(cIndex++, alpha * total);
            }
        });
    }

    public static void multAddTransAB(double alpha, DMatrix1Row A2, DMatrix1Row B, DMatrix1Row C2) {
        UtilEjml.assertTrue(A2 != C2 && B != C2, "Neither 'A' or 'B' can be the same matrix as 'C'");
        UtilEjml.assertShape(A2.numRows, B.numCols, "The 'A' and 'B' matrices do not have compatible dimensions");
        UtilEjml.assertShape(A2.numCols == C2.numRows && B.numRows == C2.numCols, "C is not compatible with A and B");
        EjmlConcurrency.loopFor(0, A2.numCols, i -> {
            int cIndex = i * B.numRows;
            int indexB = 0;
            for (int j = 0; j < B.numRows; ++j) {
                int indexA = i;
                int end = indexB + B.numCols;
                double total = 0.0;
                while (indexB < end) {
                    total += A2.data[indexA] * B.data[indexB++];
                    indexA += A2.numCols;
                }
                C2.plus(cIndex++, alpha * total);
            }
        });
    }

    public static void multAddTransB(double alpha, DMatrix1Row A2, DMatrix1Row B, DMatrix1Row C2) {
        UtilEjml.assertTrue(A2 != C2 && B != C2, "Neither 'A' or 'B' can be the same matrix as 'C'");
        UtilEjml.assertShape(A2.numCols, B.numCols, "The 'A' and 'B' matrices do not have compatible dimensions");
        UtilEjml.assertShape(A2.numRows == C2.numRows && B.numRows == C2.numCols, "C is not compatible with A and B");
        EjmlConcurrency.loopFor(0, A2.numRows, xA -> {
            int cIndex = xA * B.numRows;
            int aIndexStart = xA * B.numCols;
            int end = aIndexStart + B.numCols;
            int indexB = 0;
            for (int xB = 0; xB < B.numRows; ++xB) {
                int indexA = aIndexStart;
                double total = 0.0;
                while (indexA < end) {
                    total += A2.data[indexA++] * B.data[indexB++];
                }
                C2.plus(cIndex++, alpha * total);
            }
        });
    }
}

