## dice.py
import random

class Dice:
    def __init__(self, sides: int = 6):
        """
        Initialize the dice with a given number of sides.
        
        Args:
            sides (int): The number of sides on the dice, default is 6.
        """
        self._sides = sides

    def roll(self) -> int:
        """
        Simulate rolling the dice and return the result.

        Returns:
            int: The number rolled on the dice, between 1 and the number of sides.
        """
        return random.randint(1, self._sides)
