## ui.py

from game import Game

class UI:
    def start(self):
        difficulty = self.select_difficulty()
        game = Game(difficulty)
        game.start_game()
        self.display_welcome_message(game)

        feedback = ""
        while feedback != "Correct! Game over.":
            guess = self.get_user_input("Enter your guess: ")
            if self.is_valid_guess(guess):
                feedback = game.check_guess(int(guess))
                self.display_message(feedback)
                self.show_attempts(game.get_attempts())
                self.show_history(game.get_history())
            else:
                self.display_message("Please enter a valid number.")

    def display_welcome_message(self, game):
        print("Welcome to the Number Guessing Game!")
        print(f"Guess the number between {game.min_range} and {game.max_range}.")

    def is_valid_guess(self, guess):
        return guess.isdigit()

    def display_message(self, message: str):
        print(message)

    def get_user_input(self, prompt: str) -> str:
        return input(prompt)

    def show_attempts(self, attempts: int):
        print(f"Number of attempts: {attempts}")

    def show_history(self, history: list):
        print("Guess history:")
        for guess in history:
            print(guess)

    def select_difficulty(self) -> str:
        while True:
            difficulty = input("Select difficulty (easy, medium, hard): ").lower()
            if difficulty in ['easy', 'medium', 'hard']:
                return difficulty
            else:
                self.display_message("Invalid difficulty. Please choose 'easy', 'medium', or 'hard'.")
