## game.py

import random

class Game:
    def __init__(self, difficulty: str = 'medium'):
        self.min_range, self.max_range = self._set_difficulty(difficulty)
        self.secret_number = random.randint(self.min_range, self.max_range)
        self.attempts = []

    def _set_difficulty(self, difficulty: str):
        difficulties = {
            'easy': (1, 10),
            'medium': (1, 100),
            'hard': (1, 1000)
        }
        return difficulties.get(difficulty, (1, 100))

    def start_game(self):
        self.secret_number = random.randint(self.min_range, self.max_range)
        self.attempts = []

    def check_guess(self, guess: int) -> str:
        self.attempts.append(guess)
        if guess < self.secret_number:
            return "It's higher."
        elif guess > self.secret_number:
            return "It's lower."
        else:
            return "Correct! Game over."

    def get_attempts(self) -> int:
        return len(self.attempts)

    def get_history(self) -> list:
        return self.attempts
