# MorphAgent: Empowering Agents through Self-Evolving Profiles and Decentralized Collaboration

## Quick Start

### Installation

Our project is built on [MetaGPT](https://github.com/geekan/MetaGPT), thus you need to install MetaGPT first.

```bash
cd ./MetaGPT
pip install -e .
```

We have additional packages.

```bash
pip install sentence_transformers
pip install tf-keras
pip install spacy
pip install nltk
python -m spacy download en_core_web_sm
```

### Configuration

First, you should add your api key in `.env` file.

```
OPENAI_API_KEY=your_openai_api_key_here
AZURE_OPENAI_API_KEY=your_azure_openai_api_key_here
```

And set your agents configuration `default.yaml`.

```yaml
# Single configuration, used for all agents (if individual configs are not provided)
agent:
  api_type: "openai"
  base_url: "https://api.openai.com/v1"
  api_key: ${OPENAI_API_KEY}
  model: "gpt-3.5-turbo"
  temperature: 0.7

# Individual agent configurations (if provided, they will override the single configuration)
agents:
  - api_type: "openai"
    base_url: "https://api.openai.com/v1"
    api_key: ${OPENAI_API_KEY}
    model: "gpt-3.5-turbo"
    temperature: 0.7
  - api_type: "azure"
    base_url: "https://your-azure-endpoint.openai.azure.com"
    api_key: ${AZURE_OPENAI_API_KEY}
    model: "gpt-4"
    temperature: 0.5

assistant:
  api_type: "openai"
  base_url: "https://api.openai.com/v1"
  api_key: ${OPENAI_API_KEY}
  model: "gpt-4"
  temperature: 0
```

### Usage

Now you can use MorphAgent at CLI

```python
python main.py --processes 1
```

Enjoy it!