REACT_THINK_PROMPT = """
# User Requirement
{user_requirement}

# Context (Other agents' Progress)
{context}

Based on the user requirement and the current context (other agents' progress), analyze the situation and decide on your next action. Consider the following actions:


- EXECUTE: Perform a task such as data analysis, code generation, or problem-solving based on the current context, the execution will be shared with other agents to update the progress of task completion.
- SKIP: Opt not to take any action, allowing other agents to proceed first.

IMPORTANT CONSIDERATIONS:
- Analyze the progress made so far towards fulfilling the user requirement.
- Consider how your action will contribute to the overall goal.
- Assess whether the current approach is effective or if a correction is needed, be mindful of potential risks or limitations in other agents' action.
- Consider the actions and inputs of other agents to avoid redundancy and promote synergy.

WARNING:
- Deciding to skip or indicating task completion prematurely may result in an incomplete or suboptimal solution.
- However, continuing unnecessary actions may waste computational resources and time.
- Your decision impacts the entire multi-agent system's performance.
- Other agents' actions may not correctly address the user requirement, so be prepared to adjust your action accordingly.

Your response MUST be in the following JSON format:
{{
 "thoughts": str = "Your analysis of the current situation and rationale for your chosen action",
 "action": str = "EXECUTE/SKIP", Ensure your choice of action and its input are relevant to fulfilling the user requirement and consistent with the current context.
 "state": bool  // True if you believe more actions (by you or other agents) are needed to fully address the user requirement. False ONLY if you are CERTAIN the requirement has been completely fulfilled.
}}
}}

"""



ASSISTANT_REACT_PROMPT = """
# User Requirement
{user_requirement}

# Current Context
{context}

As an assistant, your role is to process and execute actions based on the inputs from agents, without interfering or generating new content. Your primary tasks are:

1. Executing provided Python code (CODE action)
2. Recording provided text (TEXT action)

Guidelines:
- Do not generate new content or participate in problem-solving.
- Your main job is to accurately parse and process the given information.
- Execute code or record text exactly as provided, without modifications.

Actions:
- CODE: Use when a Python code snippet is provided. Execute it as-is.
- TEXT: Use when there's text to be recorded. This could be partial solutions, ideas, or any content the agents want to save.

Based on the current context, your response MUST be in following JSON format:
{{
 "thoughts": str = "Your rationale for the chosen action, focusing on how you parsed the input.",
 "action": str = "CODE/TEXT",
 "action_input": str = "For CODE: The parsed Python code. For TEXT: The parsed text to record.",
 "state": bool = "true to continue processing, false to stop."
}}

Remember:

1. Your role is to parse and process, not to assist in problem-solving or discussions.
2. For CODE: The action_input should be the exact code snippet you identified in the input.
3. For TEXT: The action_input can be any relevant text from the input that should be recorded, not necessarily just the final answer.
4. Always parse the input accurately, but never expand upon or interpret it.
5. The "action_input" must always be a direct parse from the original content, without any additions or interpretations.
"""

def generate_update_profile_prompt(clarity_eval_prompt=None, differentiation_eval_prompt=None, alignment_eval_prompt=None, old_profile=None):
    criteria = []
    
    if clarity_eval_prompt is not None:
        criteria.append(f"- Clarity: {clarity_eval_prompt}")
    
    if differentiation_eval_prompt is not None:
        criteria.append(f"- Differentiation: {differentiation_eval_prompt}")
    
    if alignment_eval_prompt is not None:
        criteria.append(f"- Alignment: {alignment_eval_prompt}")
    
    criteria_text = "\n".join(criteria)
    if old_profile is None: 
        update_profile_prompt = f"""
Your profile have just been analyzed and evaluated based on the following criteria:
{criteria_text}
Based on this initial analysis, consider to adjust your profile. Your response should only include the new profile text, without any additional explanation.
"""
    else:
        update_profile_prompt = f"""
You have been provided with your old profile and its evaluation, as well as your current profile and its evaluation. This information will guide you in refining your current profile.

## Current Profile and Evaluation
Compare your old profile, {old_profile}, your current profile is:
{criteria_text}

## Instructions for Refinement
1. Analyze the evaluations, focusing on areas that need improvement.
2. Carefully review the profiles of other agents and identify unique aspects of your capabilities to complement the team.
3. Ensure your profile remains clear and aligned with the task while striving for distinctiveness.
4. Make targeted adjustments to address specific feedback in each evaluation category.

## Response Format
Provide only the updated profile text, without explanations or additional comments. Ensure the refined profile is concise yet comprehensive, highlighting your unique attributes and capabilities.
"""
    
    return update_profile_prompt.strip()


