## main.py
import tkinter as tk
from tkinter import messagebox
from document_parser import DocumentParser
from word_cloud_generator import WordCloudGenerator
from ui_manager import UIManager

class Main:
    def __init__(self):
        self.ui_manager = UIManager(self.generate_word_cloud)
        self.word_cloud_generator = WordCloudGenerator()
        self.document_parser = DocumentParser()

    def generate_word_cloud(self, user_input):
        """
        Generates a word cloud based on the user input.

        :param user_input: A dictionary containing the file path and settings.
        :return: None
        """
        file_path = user_input.get('file_path')
        settings = user_input.get('settings', {})

        # Parse the document to get word frequencies
        frequencies = self.document_parser.parse_document(file_path)
        if not frequencies:
            messagebox.showerror("Error", "Failed to parse the document or the document is empty.")
            return

        # Generate the word cloud image
        word_cloud_image = self.word_cloud_generator.generate_word_cloud(frequencies, settings)
        if word_cloud_image:
            self.ui_manager.display_word_cloud(word_cloud_image)
        else:
            messagebox.showerror("Error", "Failed to generate the word cloud image.")

    def main(self):
        """
        The main entry point for the application.
        """
        self.ui_manager.run()

if __name__ == "__main__":
    main_app = Main()
    main_app.main()
