## constants.py

# Import necessary modules if required
# No external imports required for constants

# Define a class to hold all the constants for the game
class Constants:
    # Define the size of the grid for the 2048 game
    GRID_SIZE: int = 4  # 4x4 grid

    # Define the window width and height for the game display
    WINDOW_WIDTH: int = 400
    WINDOW_HEIGHT: int = 500  # Extra space for score display and controls

    # Define the background color for the game window
    BACKGROUND_COLOR: tuple = (187, 173, 160)  # RGB color value

    # Define the colors for different tiles in the game
    TILE_COLORS: dict = {
        0: (205, 193, 180),  # Empty tile color
        2: (238, 228, 218),
        4: (237, 224, 200),
        8: (242, 177, 121),
        16: (245, 149, 99),
        32: (246, 124, 95),
        64: (246, 94, 59),
        128: (237, 207, 114),
        256: (237, 204, 97),
        512: (237, 200, 80),
        1024: (237, 197, 63),
        2048: (237, 194, 46),
        # Additional colors for higher tiles if needed
    }

    # Define any other constants that may be required by the game and UI
    FONT_NAME: str = 'arial'  # Default font for text display
    FONT_SIZE: int = 20  # Default font size for text display
    GAME_TITLE: str = '2048'  # Title of the game window
    TILE_SIZE: int = WINDOW_WIDTH // GRID_SIZE  # Size of one tile
    TILE_MARGIN: int = 5  # Margin between tiles
