import pygame
import sys
from game import Game
from ui import UI

class Main:
    def __init__(self):
        self.game = Game()
        self.ui = UI()

    def run(self):
        clock = pygame.time.Clock()
        running = True
        while running:
            for event in pygame.event.get():
                if event.type == pygame.QUIT:
                    running = False
                if event.type == pygame.KEYDOWN:
                    self.handle_key_press(event.key)
                if event.type == pygame.MOUSEBUTTONDOWN:
                    self.ui.handle_undo_button_click(self.game)

            self.ui.draw(self.game._grid, self.game._current_score, self.game._high_score, self.game.check_game_over())
            clock.tick(30)

        pygame.quit()
        sys.exit()

    def handle_key_press(self, key):
        direction = None
        if key == pygame.K_UP:
            direction = 'up'
        elif key == pygame.K_DOWN:
            direction = 'down'
        elif key == pygame.K_LEFT:
            direction = 'left'
        elif key == pygame.K_RIGHT:
            direction = 'right'

        if direction and self.game.move(direction):
            self.ui.update_display()

    def handle_game_over(self):
        self.ui.show_game_over()
        pygame.display.flip()
        pygame.time.wait(2000)
        self.game.reset_game()

if __name__ == "__main__":
    main = Main()
    main.run()
