## constants.py

# Define the screen width and height
SCREEN_WIDTH: int = 640
SCREEN_HEIGHT: int = 480

# Define the size of each block of the snake and food
BLOCK_SIZE: int = 20

# Define colors in RGB format
WHITE: tuple = (255, 255, 255)
BLACK: tuple = (0, 0, 0)
GREEN: tuple = (0, 255, 0)
RED: tuple = (255, 0, 0)

# Define snake properties
SNAKE_SPEED: int = 5
SNAKE_START_LENGTH: int = 3
SNAKE_COLOR: tuple = GREEN

# Define food properties
FOOD_COLOR: tuple = RED
FOOD_SIZE: int = BLOCK_SIZE  # Food size should match the block size

# Define game properties
FPS: int = 30  # Frames per second
SCORE_INCREMENT: int = 10
SPEED_INCREMENT: int = 1
DIFFICULTY_INCREASE_THRESHOLD: int = 50  # Points after which game difficulty increases
