## scoreboard.py
import os
import json

class Scoreboard:
    def __init__(self, high_score_file: str = "high_score.json"):
        self.high_score_file: str = high_score_file
        self.high_score: int = self.load_high_score()
        self.current_score: int = 0

    def update_score(self, score: int) -> None:
        self.current_score += score
        if self.current_score > self.high_score:
            self.high_score = self.current_score
            self.save_high_score()

    def reset_score(self) -> None:
        self.current_score = 0

    def load_high_score(self) -> int:
        if not os.path.exists(self.high_score_file):
            return 0
        with open(self.high_score_file, 'r') as file:
            data = json.load(file)
            return data.get('high_score', 0)

    def save_high_score(self) -> None:
        with open(self.high_score_file, 'w') as file:
            json.dump({'high_score': self.high_score}, file)

    # This method is not in the design, but it's necessary to call save_high_score
    # if the current high score is greater than the one stored in the file.
    # It's implemented based on the debug logs.
    def try_save_high_score(self) -> None:
        if self.high_score > self.load_high_score():
            self.save_high_score()
