import ast
import asyncio
import json
import os
from .utils import UniPyExecutor
# from metagpt.logs import logger
import argparse

TIMEOUT_LIMIT = 10  # seconds

def load_result(result_file):
    if not os.path.exists(result_file):
        with open(result_file, 'w') as file:
            json.dump([], file)

    with open(result_file, 'r') as file:
        data = json.load(file)
    return data

async def process_item(item: dict):
    
    task_id = item["task_id"]
    print(task_id)
    task = item["complete_prompt"]
    req_libs = ast.literal_eval(item["libs"])
    tests = item["test"]
    
    # task = item["input"]
    # tests = item["label"]
    # req_libs = []
    try: 
        answer = item["attempt_answer"]["code"]
        # answer = item["response"] 
    except:
        return False, task, "No answer", "No answer"
    
    # Create package installation code
    install_code = []
    if req_libs:
        install_code.append("import sys")
        install_code.append("import subprocess")
        install_code.append("def install(package):")
        install_code.append("    subprocess.check_call([sys.executable, '-m', 'pip', 'install', package])")
        for req in req_libs:
            install_code.append(f"try:")
            install_code.append(f"    import {req}")
            install_code.append(f"except ImportError:")
            install_code.append(f"    install('{req}')")
            if req == "nltk":
                install_code.append(f"nltk.download('punkt_tab')")
    
    answer = "\n".join(install_code) + "\n" + answer
    


    try:
        is_solved, feedback, _ = UniPyExecutor().execute(answer, [tests], timeout=60)
        return is_solved, task, answer, feedback
    except asyncio.CancelledError:
        # logger.info("Task was cancelled.")
        raise
    except Exception as e:
        # logger.error(f"Error processing item: {e}")
        return False, task, answer, f"Error {e} processing item"




async def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("--result_jsonl_file", type=str, required=True)
    
    args = parser.parse_args()
    
    result_jsonl_file = args.result_jsonl_file
    save_analysis_file = result_jsonl_file.split(".jsonl")[0] + "_analysis.json"

    data = []
    with open(result_jsonl_file, 'r') as file:
        for line in file:
            data.append(json.loads(line))
    results = load_result(save_analysis_file)
    
    total_solved, total_executed =  (0, 0) if not results else (results[-1]["Total solved"], results[-1]["Total executed"])
    
    data = data[total_executed:]
    for item in data:
        is_solved, task, answer, feedback = await process_item(item)
        total_executed += 1
        total_solved += 1 if is_solved else 0
        accuracy = total_solved / total_executed
        updated_item = {
            "Task ID": item["task_id"],
            "Question": task,
            "Attempt answer": answer,
            "Solved": is_solved,
            "Feedback": feedback,
            "Total solved": total_solved,
            "Total executed": total_executed,
            "Accuracy": accuracy
        }
        results.append(updated_item)

        
            
        with open(save_analysis_file, 'w') as file:
            json.dump(results, file, indent=4)

asyncio.run(main())