## main.py

from flask import Flask, render_template, request, jsonify
from calculator import Calculator
import os

app = Flask(__name__)

class Main:
    def __init__(self):
        self.calculator = Calculator()
        # Bind the Flask route handlers to instance methods
        app.add_url_rule('/', 'index', self.index)
        app.add_url_rule('/add', 'add', self.add, methods=['POST'])
        app.add_url_rule('/reset', 'reset', self.reset, methods=['POST'])

    def run(self):
        # Get debug setting from environment variable, default to False
        debug_mode = os.getenv('FLASK_DEBUG', 'False') == 'True'
        app.run(debug=debug_mode)

    def index(self):
        return render_template('index.html')

    def add(self):
        data = request.get_json()
        number1 = data.get('number1', 0.0)
        number2 = data.get('number2', 0.0)
        sum_result = self.calculator.add(number1, number2)
        return jsonify(result=sum_result)

    def reset(self):
        self.calculator.reset()
        return jsonify(message="Calculator reset successfully")

if __name__ == '__main__':
    main_app = Main()
    main_app.run()  # Debug mode is now configurable
