// static/scripts.js

document.addEventListener('DOMContentLoaded', function() {
    const addButton = document.getElementById('addButton');
    const resetButton = document.getElementById('resetButton');
    const number1Input = document.getElementById('number1');
    const number2Input = document.getElementById('number2');
    const resultDiv = document.getElementById('result');

    addButton.addEventListener('click', function() {
        const number1 = parseFloat(number1Input.value) || 0;
        const number2 = parseFloat(number2Input.value) || 0;
        sendAddRequest(number1, number2);
    });

    resetButton.addEventListener('click', function() {
        sendResetRequest();
    });

    function sendAddRequest(number1, number2) {
        fetch('/add', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({ number1, number2 }),
        })
        .then(response => response.json())
        .then(data => {
            displayResult(data.result);
        })
        .catch(error => {
            console.error('Error:', error);
        });
    }

    function sendResetRequest() {
        fetch('/reset', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
        })
        .then(response => response.json())
        .then(data => {
            clearInputsAndResult();
        })
        .catch(error => {
            console.error('Error:', error);
        });
    }

    function displayResult(result) {
        resultDiv.textContent = `Result: ${result}`;
    }

    function clearInputsAndResult() {
        number1Input.value = '';
        number2Input.value = '';
        resultDiv.textContent = '';
    }
});
