## snake.py
import pygame
from constants import Constants

class Snake:
    def __init__(self):
        self.body_parts = [(Constants.SCREEN_WIDTH // 2, Constants.SCREEN_HEIGHT // 2)]
        self.direction = 'RIGHT'
        self.grow_flag = False

    def move(self):
        head_x, head_y = self.body_parts[0]
        if self.direction == 'UP':
            head_y -= Constants.BLOCK_SIZE
        elif self.direction == 'DOWN':
            head_y += Constants.BLOCK_SIZE
        elif self.direction == 'LEFT':
            head_x -= Constants.BLOCK_SIZE
        elif self.direction == 'RIGHT':
            head_x += Constants.BLOCK_SIZE

        new_head = (head_x, head_y)
        self.body_parts.insert(0, new_head)
        if not self.grow_flag:
            self.body_parts.pop()
        self.grow_flag = False

    def grow(self):
        self.grow_flag = True

    def check_collision(self) -> bool:
        head = self.body_parts[0]
        # Check collision with walls
        if (head[0] < 0 or head[0] >= Constants.SCREEN_WIDTH or
            head[1] < 0 or head[1] >= Constants.SCREEN_HEIGHT):
            return True
        # Check collision with itself
        if head in self.body_parts[1:]:
            return True
        return False

    def change_direction(self, new_direction: str):
        opposite_directions = {'UP': 'DOWN', 'DOWN': 'UP', 'LEFT': 'RIGHT', 'RIGHT': 'LEFT'}
        if (new_direction != opposite_directions.get(self.direction) and
                new_direction in opposite_directions.keys()):
            # Prevent the snake from reversing direction if it's longer than 1 block
            if len(self.body_parts) == 1 or (len(self.body_parts) > 1 and
                                              self.body_parts[1] != (self.body_parts[0][0] + Constants.BLOCK_SIZE * (1 if self.direction == 'LEFT' else -1 if self.direction == 'RIGHT' else 0),
                                                                     self.body_parts[0][1] + Constants.BLOCK_SIZE * (1 if self.direction == 'UP' else -1 if self.direction == 'DOWN' else 0))):
                self.direction = new_direction

    def get_head_position(self):
        return self.body_parts[0]

    def get_body_parts(self):
        return self.body_parts
