#The R code for algorithm (model) classes used in the simulations.

library(methods)

setGeneric("fitting",function(obj,...) standardGeneric("fitting"))
setGeneric("Pred",function(obj,...) standardGeneric("Pred"))
setGeneric("Tuning",function(obj,...) standardGeneric("Tuning"))
setGeneric("DataGen",function(obj,...) standardGeneric("DataGen"))
setGeneric("Threshold",function(obj,...) standardGeneric("Threshold"))

###ridge
setClass("ridge",slots = list(name="character",alpha="numeric",family="character"), prototype=list(name="RR",alpha=0,family="gaussian") )
setMethod("fitting","ridge",function(obj,X,Y,lambda){
  glmnet(x=X,y=Y,family =obj@family,alpha=obj@alpha,lambda =lambda)
})
setMethod("Pred","ridge",function(obj,model,X_test,lens=0){
  predict(model,X_test)
})
setMethod("Tuning","ridge",function(obj,X,Y){
  return(0.001*norm(X, type = "2")^2)
})

setMethod("DataGen","ridge",function(obj,X,beta,sigma){
  Y=X%*%beta+rnorm(dim(X)[1],0,sigma)
  return(data.frame(x=X,y=Y))
})

###lasso
setClass("lasso",slots = list(name="character",alpha="numeric",family="character"), prototype=list(name="Lasso",alpha=1,family="gaussian") )
setMethod("fitting","lasso",function(obj,X,Y,lambda){
  glmnet(x=X,y=Y,family =obj@family,alpha=obj@alpha,lambda =lambda)
})
setMethod("Pred","lasso",function(obj,model,X_test,lens=0){
  predict(model,X_test)
})
setMethod("Tuning","lasso",function(obj,X,Y){
  lasso=cv.glmnet(x=X,y=Y,type.measure="mse",family = obj@family,alpha=obj@alpha)
  return(lasso$lambda.min)
})
setMethod("DataGen","lasso",function(obj,X,beta,sigma){
  b=c(1,-1,2,-2,rep(0,dim(X)[2]-4))
  Y=X%*%b+rnorm(dim(X)[1],0,sigma)
  return(data.frame(x=X,y=Y))
})


###random forest, Case A
setClass("RF1",slots = list(name="character"),prototype = list(name="RF1"))
setMethod("fitting","RF1",function(obj,X,Y,lambda){
  datawork=data.frame(X,y=Y)
  randomForest(y~.,data=datawork,mtry=round(dim(X)[2]/3),ntree=lambda)
})
setMethod("Pred","RF1",function(obj,model,X_test,lens=0){
  predict(model,as.data.frame(x=X_test))})
setMethod("Tuning","RF1",function(obj,X,Y){
  return(500)
})
setMethod("DataGen","RF1",function(obj,X,beta,sigma){
  uX=4*(X[,1]+1)*abs(X[,3])*(X[,2]>-0.4)+4*(X[,1]-1)*(X[,2]<=-0.4)
  Y=uX+rnorm(dim(X)[1],0,sigma)
  return(data.frame(x=X,y=Y))
})
setMethod("Threshold","RF1",function(obj){
  return(2.995388)
})


##RF setting 2, the case B
setClass("RF2",slots = list(name="character"),prototype = list(name="RF2"))
setMethod("fitting","RF2",function(obj,X,Y,lambda){
  datawork=data.frame(X,y=Y)
  randomForest(y~.,data=datawork,mtry=round(dim(X)[2]/3),ntree=lambda)
})
setMethod("Pred","RF2",function(obj,model,X_test,lens=0){
  predict(model,as.data.frame(x=X_test))})
setMethod("Tuning","RF2",function(obj,X,Y){
  return(500)
})
setMethod("Threshold","RF2",function(obj){
  return(2.995388)
})
setMethod("DataGen","RF2",function(obj,X,beta,sigma){
  b=c(1,-1,2,-2,rep(0,dim(X)[2]-4))
  #uX=5*(X[,1]*X[,2]+X[,3]^2+exp(X[,4]-1))
  #Y=uX+2.25*rnorm(dim(X)[1],0,sigma)
  Y=ifelse(X%*%b>1.5,1,0)+0.1*rnorm(dim(X)[1],0,sigma)
  #uX<-c()
  #for (i in 1:length(X%*%b)) {
  #  uX[i]<-rbinom(1,1,pnorm(X%*%b))
  #}
  #Y=uX
  return(data.frame(x=X,y=Y))
})



###MLP
setClass("NN",slots = list(name="character",stepmax="numeric",rep="numeric",hidden="numeric"),
         prototype = list(name="NN",stepmax=10000,rep=1,hidden=20))
setMethod("fitting","NN",function(obj,X,Y,lambda){
  datawork=data.frame(X,y=Y)
  neuralnet(y~.,data=datawork,hidden=1,stepmax =obj@stepmax,rep=obj@rep,learningrate=lambda,act.fct = "tanh")
})
setMethod("Pred","NN",function(obj,model,X_test,lens=0){
  predict(model,X_test)})
setMethod("Tuning","NN",function(obj,X,Y){
  learningrate=0.05
  return(learningrate)})
setMethod("DataGen","NN",function(obj,X,beta,sigma){
  uX=4*(X[,1]+1)*abs(X[,3])*(X[,2]>-0.4)+4*(X[,1]-1)*(X[,2]<=-0.4)
  Y=uX+rnorm(dim(X)[1],0,sigma)
  #Y=X%*%beta+rnorm(dim(X)[1],sigma)
  return(data.frame(x=X,y=Y))
})

###SVM, Case C
setClass("SVM",slots = list(name="character"),
         prototype = list(name="SVM"))
setMethod("fitting","SVM",function(obj,X,Y,lambda){
  datawork=data.frame(X,y=Y)
  ksvm(y~.,data=datawork,C=lambda)
})
setMethod("Pred","SVM",function(obj,model,X_test,lens,type="decision"){
  predraw=predict(model,X_test)
  return(predraw)
})
setMethod("Tuning","SVM",function(obj,X,Y){
  # lambda_list=c(0.2,0.4,0.7,1,1.3,1.6,2)
  # datawork=data.frame(X,y=Y)
  # error=try(sapply(lambda_list,function(t){
  #  svmmodel=ksvm(y~.,data=datawork,C=t,cross=5)
  #  return(svmmodel@cross)})
  # )
  # if('try-error' %in% class(error))
  # {return(1)}else
  # {return(lambda_list[min(which.min(error))])}
  return(2)
})

setMethod("Threshold","SVM",function(obj){
  return(1.042941)
})
setMethod("DataGen","SVM",function(obj,X,beta,sigma){
  uX=5*(X[,1]*X[,2]+exp(X[,4]-1))
  Y=uX+2.25*rnorm(dim(X)[1],0,sigma)
  return(data.frame(x=X,y=Y))
})


###linear regression
setClass("LRs",slots = list(name="character"), prototype=list(name="LR-standard") )
setMethod("fitting","LRs",function(obj,X,Y,lambda){
  if(dim(X)[1]>=dim(X)[2])
  {datawork=data.frame(X,y=Y)
  return(lm(y~.,datawork))}else
  {X_a1=cbind(rep(1,dim(X)[1]),X)
  return(ginv(t(X_a1)%*%X_a1)%*%t(X_a1)%*%Y)}
})
setMethod("Pred","LRs",function(obj,model,X_test,lens=0){
  
  if(class(model)=="lm")
  {predict(model,as.data.frame(x=X_test))}else
  {X_a1=cbind(rep(1,dim(X_test)[1]),X_test)
  X_a1%*%model}
})
setMethod("Tuning","LRs",function(obj,X,Y){
  return(0)
})
setMethod("DataGen","LRs",function(obj,X,beta,sigma){
  uX=X%*%beta
  Y=uX+sapply(1:dim(X)[1],function(i){rnorm(1,0,sigma+abs(uX[i]))})#????Y
  return(data.frame(x=X,y=Y))
})

