
function FISTA_restart_v2(C, b::Vector{Float64}, C_b::Vector{Float64}, x0::Vector{Float64}, C_x0::Vector{Float64}, K::Int64, total_time::Float64, num_restart::Int64, freq::Int64, restart_ratio::Float64, file_path::String, ϵ::Float64)

    # extra_term = 0.5 * norm(b)^2
    results = Results()
    init_epoch = 0
    init_time = 0.0
    col_norm_square = norm.(eachcol(C)).^2
    init_metric = first_order_optv3(C, b, x0, C_x0, C_b, col_norm_square)
    n = length(x0)
    η = compute_eta(C)

    for i = 1:num_restart
        # x0, C_x0, init_metric, td = FISTA_alg(C, x0, C_x0, K, freq, init_metric, γ, blocks, row_idxs, extra_term, ηs, ubs)
        x0, C_x0, init_metric, init_epoch, init_time = FISTA_alg_v2(C, b, C_b, x0, C_x0, η, K, total_time, freq, init_metric, results, init_epoch, init_time, restart_ratio, ϵ, col_norm_square)
        @info "restart epoch: $i"
        if init_time >= total_time || init_metric < ϵ
            break
        end
    end
    exportresultstoCSV(results, file_path)
end

function FISTA_alg_v2(C, b::Vector{Float64}, C_b::Vector{Float64}, x0::Vector{Float64}, C_x0::Vector{Float64}, η::Float64, K::Int64, total_time::Float64, freq::Int64,
                        init_metric::Float64, results::Results, init_epoch::Int64, init_time::Float64, restart_ratio::Float64, ϵ, col_norm_square)
    t0 = time()
    m, n = size(C)
    prev_x = x0[:]
    x = x0[:]
    p = zero(x)
    t = 1
    for k = 1:K
        prev_t = t
        t = (1+sqrt(1+4*t^2))/2
        β = (prev_t-1)/t
        p = x + β * (x - prev_x)
        w = p - η * (((C*p)'*C)' - C_b)
        prev_x[:] = x[:]
        # x[:] = max.(0, min.(w, ubs))
        x[:] = max.(0.0, w)

        if k % freq == 0
            C_x = C * x
            metric = first_order_optv3(C, b, x, C_x, C_b, col_norm_square)
            func_value = 0.5 * norm(C_x - b)^2
            td = time() - t0
            @info "k: $k, time: $(td+init_time), metric: $metric,  func_value: $func_value"

            logresult!(results, k + init_epoch, td+init_time, metric, func_value)
            if metric <= restart_ratio * init_metric || td + init_time > total_time || metric < ϵ || k == K
                return x, C_x, metric, k + init_epoch, td + init_time
            end
        end

    end
end
