## Getting Started
```Shell
conda deactivate; conda env remove -n ours -y 
conda create -n ours python=3.8 -y 
conda activate ours 

conda install openblas-devel -c anaconda -y
pip install pip==21.3.1
pip install torch==1.10.1+cu111 torchvision==0.11.2+cu111 torchaudio==0.10.1 -f https://download.pytorch.org/whl/cu111/torch_stable.html
sudo apt update
sudo apt install gcc-10 g++-10 -y
sudo update-alternatives --install /usr/bin/gcc gcc /usr/bin/gcc-10 10
sudo update-alternatives --install /usr/bin/g++ g++ /usr/bin/g++-10 10
export CC=/usr/bin/gcc-10
export CXX=/usr/bin/g++-10
pip install pip==24.2

conda install -c conda-forge cudatoolkit-dev=11.1 -y 
git clone https://github.com/NVIDIA/MinkowskiEngine.git
cd MinkowskiEngine 
python setup.py install --blas_include_dirs=${CONDA_PREFIX}/include --blas=openblas 
cd .. 
pip install tensorboard setuptools==52.0.0 six pyyaml easydict gitpython wandb 
pip install torch-scatter -f https://data.pyg.org/whl/torch-1.10.1+cu111.html 
pip install tqdm pandas scikit-learn opencv-python platformdirs

```

### Train

`SynLiDAR-to-SemanticKITTI`: 
```
gpus=0 ; git pull ; CUDA_VISIBLE_DEVICES=$gpus python train_ours.py --cfg=configs/main_exp/syn2semkitti.yaml
```

`SynLiDAR-to-SemanticPOSS`: 
```
gpus=0 ; git pull ; CUDA_VISIBLE_DEVICES=$gpus python train_ours.py --cfg=configs/main_exp/syn2semposs.yaml
```


## Test

For example, test in `SynLiDAR-to-SemanticKITTI`.

```
gpus=0; CUDA_VISIBLE_DEVICES=$gpus python infer.py --cfg configs/main_exp/syn2semkitti.yaml --batch_size 12 --num_classes 20 --dataset_name SemanticKITTI  --result_dir [your_path] --checkpoint_path [your_path]

python eval_performance.py --dataset ./DATA_DIR/semantickitti/sequences --datacfg utils/semantic-kitti.yaml --sequences 08 --num-classes 20 --predictions [your_path]
```

test in `SynLiDAR-to-SemanticPOSS`.

```
gpus=0; CUDA_VISIBLE_DEVICES=$gpus python infer.py --cfg configs/main_exp/syn2semposs.yaml --batch_size 12 --num_classes 14 --dataset_name SemanticPOSS  --result_dir [your_path] --checkpoint_path [your_path]

python eval_performance.py --dataset ./DATA_DIR/semanticposs/sequences --datacfg utils/semantic-poss.yaml --sequences 03 --num-classes 14 --predictions [your_path]
```
