# Copyright (c) Facebook, Inc. and its affiliates. All Rights Reserved.
import logging
import os
import sys, shutil

def setup_logger(name, cfg, filename="log.txt", distributed_rank=1):
    
    save_dir = cfg.TRAIN.LOG_DIR
    os.makedirs(os.path.join(save_dir, 'files'), exist_ok=True)

    # 학습 재개 시 파일 복사 방지
    # if not cfg.TRAIN.DEBUG and not cfg.TRAIN.RESUME:
    if not cfg.TRAIN.DEBUG:
        if not os.path.exists(os.path.join(save_dir, 'files', 'network')):
            shutil.copytree('network', os.path.join(save_dir, 'files', 'network'))
        if not os.path.exists(os.path.join(save_dir, 'files', 'dataset')):
            shutil.copytree('dataset', os.path.join(save_dir, 'files', 'dataset'))

        shutil.copy('train_DGT_ST.py', os.path.join(save_dir, 'files', 'train_DGT_ST.py'))
        shutil.copy('trainer_PCAN.py', os.path.join(save_dir, 'files', 'trainer_PCAN.py'))
        shutil.copy('trainer_ADVENT.py', os.path.join(save_dir, 'files', 'trainer_ADVENT.py'))
        shutil.copy('trainer_SAM_LM.py', os.path.join(save_dir, 'files', 'trainer_SAM_LM.py'))

        shutil.copy(cfg.TRAIN.config_file, os.path.join(save_dir, 'files', os.path.basename(cfg.TRAIN.config_file)))
    
    log_fname = os.path.join(save_dir, 'log_train.txt')

    logger = logging.getLogger(name)
    logger.setLevel(logging.DEBUG)

    # 기존 핸들러 제거
    if logger.hasHandlers():
        logger.handlers.clear()
    
    # 마스터 프로세스가 아닌 경우 로그 설정 생략
    if distributed_rank > 0:
        return logger

    ch = logging.StreamHandler(stream=sys.stdout)
    ch.setLevel(logging.DEBUG)
    formatter = logging.Formatter("%(asctime)s %(name)s %(levelname)s: %(message)s")
    ch.setFormatter(formatter)
    logger.addHandler(ch)

    if save_dir:
        # 파일 핸들러를 append 모드로 열기
        if cfg.TRAIN.RESUME:
            fh = logging.FileHandler(os.path.join(save_dir, filename), mode='a')
        else:
            fh = logging.FileHandler(os.path.join(save_dir, filename))
        fh.setLevel(logging.DEBUG)
        fh.setFormatter(formatter)
        logger.addHandler(fh)
    return logger

def save_tb(tb_writer, info_name, info_paras, save_iter):
    for name, para in zip(info_name, info_paras):
        tb_writer.add_scalar(name, para, save_iter)
