import yaml
from easydict import EasyDict
# from pathlib import Path
import os
# This file is copied from OpenPcSeg https://github.com/PJLab-ADG/OpenPCSeg/blob/master/tools/utils/train/config.py

def merge_new_config(config, new_config):
    if '_BASE_CONFIG_' in new_config:
        with open(new_config['_BASE_CONFIG_'], 'r') as f:
            try:
                yaml_config = yaml.safe_load(f, Loader=yaml.FullLoader)
            except:
                yaml_config = yaml.safe_load(f)
        config.update(EasyDict(yaml_config))

    for key, val in new_config.items():
        if not isinstance(val, dict):
            config[key] = val
            continue
        if key not in config:
            config[key] = EasyDict()
        merge_new_config(config[key], val)

    return config

def cfg_from_yaml_file(cfg_file, config):
    with open(cfg_file, 'r', encoding='utf-8') as f:
        try:
            new_config = yaml.safe_load(f)  # Loader 인자 제거
        except UnicodeDecodeError as e:
            print(f"UTF-8 failed: {e}")
            raise e
        except Exception as e:
            print(f"YAML error: {e}")
            raise e

        merge_new_config(config=config, new_config=new_config)

    return config

# def cfg_from_yaml_file(cfg_file, config):
#     with open(cfg_file, 'r') as f:
#         try:
#             new_config = yaml.safe_load(f, Loader=yaml.FullLoader)
#         except:
#             new_config = yaml.safe_load(f)

#         merge_new_config(config=config, new_config=new_config)

#     return config

