



class KV_Cache:
    """
    A class representing the KV Cache.
    """

    def __init__(
        self,
        layer_num: int,
        batch_size: int,
        max_length: int,
        num_key_value_heads: int,
        head_dim: int,
        dtype: str,
        layer_mapping: dict
    ) -> None:
        """ Initializes the KV Cache.
        Args:
            layer_num (int)
            batch_size (int)
            num_key_value_heads (int)
            max_length (int)
            head_dim (int)
            dtype (str)
            layer_mapping (dict)
        """

        self.layer_num = layer_num
        self.batch_size = batch_size
        self.max_length = max_length
        self.kv_head = num_key_value_heads
        self.head_dim = head_dim
        self.dtype = dtype
        self.layer_mapping = layer_mapping
        self.context = 0
