from glob import glob
from setuptools import setup, Extension
import numpy as np
import pybind11
from setuptools.command.build_ext import build_ext
import setuptools
import os
import sys
from pybind11.setup_helpers import Pybind11Extension, build_ext

include_dirs = [
    pybind11.get_include(),
    np.get_include(),
    os.path.join(sys.prefix, 'include'),
        '/usr/local/include/faiss',
        '/usr/local/cuda/include',
        '/usr/local/include',
]

include_dirs.extend(['../include/', '../include/efanna2e', '../thirdparty/robin-map/include'])
module = Pybind11Extension('RAIndex',
            sources=['index_bindings.cpp', '../src/index.cpp', '../src/index_ra.cpp',
                    ],
            include_dirs=include_dirs,
            library_dirs=['/usr/local/lib'],
            libraries=['faiss_avx2'],
            language='c++')

def has_flag(compiler, flagname):
    """Return a boolean indicating whether a flag name is supported on
    the specified compiler.
    """
    import tempfile
    with tempfile.NamedTemporaryFile('w', suffix='.cpp') as f:
        f.write('int main (int argc, char **argv) { return 0; }')
        try:
            compiler.compile([f.name], extra_postargs=[flagname])
        except setuptools.distutils.errors.CompileError:
            return False
    return True
class BuildExt(build_ext):
    """A custom build extension for adding compiler-specific options."""
    c_opts = {
        'unix': [
            '-Ofast', '-fopenmp', '-DNDEBUG',
            '-march=native', '-mtune=native', '-ftree-vectorize','-Wall', '-DINFO', '-mavx2',  
            '-ltcmalloc_minimal', '-fno-builtin-malloc'
            '-fno-builtin-calloc', '-fno-builtin-realloc', '-fno-builtin-free'
            ],  
    }
    link_opts = {
        'unix': [],
    }

    c_opts['unix'].append("-fopenmp")
    
    link_opts['unix'].extend(['-fopenmp'])

    def build_extensions(self):
        ct = self.compiler.compiler_type
        opts = self.c_opts.get(ct, [])
        for ext in self.extensions:
            ext.extra_compile_args.extend(opts)
            ext.extra_link_args.extend(self.link_opts.get(ct, []))

        build_ext.build_extensions(self)


setup(name='RAIndex',
    version='1.0',
    description='Python bindings for RAIndex',
    ext_modules=[module],
    cmdclass={'build_ext': BuildExt},
    install_requires=['numpy', 'pybind11']
)