#include <efanna2e/index.h>
namespace efanna2e {
Index::Index(const size_t dimension, const size_t n, Metric metric = L2)
    : dimension_(dimension), nd_(n), has_built(false) {
    metric_ = metric;
    switch (metric_) {
        case efanna2e::L2:
            distance_ = new DistanceL2();
            break;
        case efanna2e::COSINE:
            
            distance_ = new DistanceCosine();
            break;
        case efanna2e::INNER_PRODUCT:
            distance_ = new DistanceInnerProduct();
            break;
        default:
            distance_ = new DistanceL2();
            break;
    }
}
Index::~Index() {
    delete distance_;
}
}  
