close all
clear all

n = 600;
T = 3000;
eta = n/10;
numExp = 10;
r = 5; 

avg_signalToNoiseRatio = 0;
avg_errorInitial = 0;
avg_numIterCondHolds_Z = 0;
avg_firstIterConditionHolds_Z = 0;
avg_numIterCondHolds_X = 0;
avg_firstIterConditionHolds_X = 0;
avg_rank_ergodic = 0;
avg_error_ergodic = 0;
avg_gap_ergodic = 0;
avg_dual_gap_ergodic = 0;
avg_error_dualGapMin = 0;
avg_gap_dualGapMin = 0;
avg_minDualGap = 0;

for i = 1:numExp
    
    Z_0 = randn(n,r);
    norm_Z0 = norm(Z_0,'fro');
    Z_0 = Z_0*(sqrt(r)/norm_Z0); 
    N = sprand(n,n,1/sqrt(n));
    N(N~=0) = 2*rand(size(nonzeros(N)))-1;
    N(N>0) = 1;
    N(N<0) = -1;
    M = Z_0*Z_0' + 0.5*(N + N');    
    rSVD = r;
    tau = 0.95*trace(Z_0*Z_0');
    P = Z_0*Z_0';
    
    signalToNoiseRatio = norm(Z_0*Z_0','fro')^2/norm(0.5.*(N + N'),'fro')^2;
    avg_signalToNoiseRatio = avg_signalToNoiseRatio + signalToNoiseRatio/numExp;
   
    
    % EXTRA-GRADIENT
    
    [U,S] = eigs(M,n,'largestreal'); %projection
    eigens = projsplx(diag(S),tau);
    X = U*diag(eigens)*U';
    X_min = X;
    X_initial = X;
    
    Y = sign(X-M);
    Y_min = Y;
    
    X_dualGapMin = X;
    Y_dualGapMin = Y;
    
    errorInitial = norm((trace(Z_0*Z_0')/tau)*X-(Z_0*Z_0'),'fro')^2 / norm(Z_0*Z_0','fro')^2;
    avg_errorInitial = avg_errorInitial + errorInitial ./ numExp;
    
    [U2,S2] = eigs(Y,1,'smallestreal');
    dual_gapX_dualGapMin = trace((X-tau*(U2(:,1)*U2(:,1)'))'*(Y));
    dual_gapY_dualGapMin = trace((Y-sign(X-M))'*(X-M));
    minDualGap = dual_gapX_dualGapMin - dual_gapY_dualGapMin;
    
    checkCondition_Z = zeros(T,1);
    checkCondition_X = zeros(T,1); 
    Z_ergodic = zeros(n);
    W_ergodic = zeros(n);
    
    f_min = trace((X-M)'*Y);
    
    for t = 1:T
        
        grad_X = Y;
        [U,S] = eigs(X-eta*grad_X,rSVD+1,'largestreal');
        eigens = projsplx(diag(S(1:rSVD,1:rSVD)),tau);
        Z = U(:,1:rSVD)*diag(eigens)*U(:,1:rSVD)';
        
        if sum(diag(S(1:rSVD,1:rSVD))) >= tau+rSVD*S(rSVD+1,rSVD+1)
            checkCondition_Z(t) = 1;
        else
             pp=0;
        end
        
        Z_ergodic = Z_ergodic + Z/T;
        
        grad_Y = X-M;
        W = Y + eta*grad_Y;
        W(W>1) = 1;     
        W(W<-1) = -1;
        
        W_ergodic = W_ergodic + W/T;
        
        grad_Z = W;
        [U,S] = eigs(X-eta*grad_Z,rSVD+1,'largestreal');
        eigens = projsplx(diag(S(1:rSVD,1:rSVD)),tau);
        X = U(:,1:rSVD)*diag(eigens)*U(:,1:rSVD)';
        
        if sum(diag(S(1:rSVD,1:rSVD))) >= tau+rSVD*S(rSVD+1,rSVD+1)
            checkCondition_X(t) = 1;
        end
        
        grad_W = Z-M;
        Y = Y + eta*grad_W;
        Y(Y>1) = 1;     
        Y(Y<-1) = -1;
       
        
        [U2,S2] = eigs(Y,1,'smallestreal');
        dual_gapX_dualGapMin = trace((X-tau*(U2(:,1)*U2(:,1)'))'*(Y));
        dual_gapY_dualGapMin = trace((Y-sign(X-M))'*(X-M));
        dual_gap_dualGapMin = dual_gapX_dualGapMin - dual_gapY_dualGapMin;
        if dual_gap_dualGapMin < minDualGap
            minDualGap = dual_gap_dualGapMin;
            X_dualGapMin = X;
            Y_dualGapMin = Y;
        end
        
        [U2,S2] = eigs(W,1,'smallestreal');
        dual_gapX_dualGapMin = trace((Z-tau*(U2(:,1)*U2(:,1)'))'*(W));
        dual_gapY_dualGapMin = trace((W-sign(Z-M))'*(Z-M));
        dual_gap_dualGapMin = dual_gapX_dualGapMin - dual_gapY_dualGapMin;
        if dual_gap_dualGapMin < minDualGap
            minDualGap = dual_gap_dualGapMin;
            X_dualGapMin = Z;
            Y_dualGapMin = W;
        end
    end
    
    f_opt = trace((Z_ergodic-M)'*W_ergodic);
    
    avg_minDualGap = avg_minDualGap + minDualGap/numExp;
    
    numIterCondHolds_Z = nnz(checkCondition_Z);
    avg_numIterCondHolds_Z = avg_numIterCondHolds_Z + numIterCondHolds_Z ./ numExp;
    firstIterConditionHolds_Z = find(checkCondition_Z,1,'first');
    avg_firstIterConditionHolds_Z = avg_firstIterConditionHolds_Z +firstIterConditionHolds_Z/numExp;
    
    numIterCondHolds_X = nnz(checkCondition_X);
    avg_numIterCondHolds_X = avg_numIterCondHolds_X + numIterCondHolds_X ./ numExp;
    firstIterConditionHolds_X = find(checkCondition_X,1,'first');
    avg_firstIterConditionHolds_X = avg_firstIterConditionHolds_X +firstIterConditionHolds_X/numExp;
    

    
    error_ergodic = norm((trace(Z_0*Z_0')/tau)*Z_ergodic-Z_0*Z_0','fro')^2 / norm(Z_0*Z_0','fro')^2;
    avg_error_ergodic = avg_error_ergodic + error_ergodic ./ numExp;
    
    
    error_dualGapMin = norm((trace(Z_0*Z_0')/tau)*X_dualGapMin-Z_0*Z_0','fro')^2 / norm(Z_0*Z_0','fro')^2;
    avg_error_dualGapMin = avg_error_dualGapMin + error_dualGapMin ./ numExp;
    
    rank_ergodic = rank(Z_ergodic);
    avg_rank_ergodic = avg_rank_ergodic + rank_ergodic ./ numExp;
    
    [U1,S1] = eigs(-W_ergodic,rSVD+1,'largestreal');
    gap = S1(rSVD,rSVD) - S1(rSVD+1,rSVD+1);
    avg_gap_ergodic = avg_gap_ergodic + gap ./ numExp;
    
    [U4,S4] = eigs(-Y_dualGapMin,rSVD+1,'largestreal');
    gap_dualGapMin = S4(rSVD,rSVD) - S4(rSVD+1,rSVD+1);
    avg_gap_dualGapMin = avg_gap_dualGapMin + gap_dualGapMin ./ numExp;
    
    dual_gapX_ergodic = trace((Z_ergodic-tau*(U1(:,1)*U1(:,1)'))'*(W_ergodic));
    dual_gapY_ergodic = trace((W_ergodic-sign(Z_ergodic-M))'*(Z_ergodic-M));
    dual_gap_ergodic = dual_gapX_ergodic - dual_gapY_ergodic;
    avg_dual_gap_ergodic = avg_dual_gap_ergodic + dual_gap_ergodic/numExp;
    
end

    
avg_signalToNoiseRatio
avg_errorInitial
avg_numIterCondHolds_Z
avg_firstIterConditionHolds_Z
avg_numIterCondHolds_X
avg_firstIterConditionHolds_X
avg_rank_ergodic
avg_error_ergodic
avg_gap_ergodic
avg_dual_gap_ergodic
avg_error_dualGapMin
avg_gap_dualGapMin
avg_minDualGap