close all
clear all

n = 600;
density = 0.1;

SNR = 1;
lambda = 0.0014;
T = 1000;
eta = 1/(2*lambda);
numExp = 10;
r = 1; 

avg_signalToNoiseRatio = 0;
avg_XinitialNorm1 = 0;
avg_errorInitial_LR = 0;
avg_numIterCondHolds_Z = 0;
avg_firstIterConditionHolds_Z = 0;
avg_numIterCondHolds_X = 0;
avg_firstIterConditionHolds_X = 0;
avg_Xnorm1_ergodic = 0;
avg_error_min = 0;
avg_rank_ergodic = 0;
avg_Xnorm1_min = 0;
avg_error_ergodic = 0;
avg_gap = 0;
avg_dual_gap_ergodic = 0;
avg_dual_gap_min = 0;
avg_c_noise = 0;
avg_minDualGap = 0;
avg_error_dualGapMin = 0;
avg_Xnorm1_dualGapMin = 0;
avg_gap_dualGapMin = 0;


for i = 1:numExp
    
    z = sprand(n,r,density);
    z(z~=0) = randi([1,10],size(nonzeros(z)));
    norm_z = norm(z,'fro');
    z = z/norm_z; 
    N = rand(n,n);%randn(n,n)+0.5;
    c_noise = sqrt(4/SNR)*(1/norm((N + N'),'fro'));
    avg_c_noise = avg_c_noise + c_noise/numExp;
    M = z*z' + (c_noise/2)*(N + N'); 
    P=z*z';
    rSVD = r;
    
    signalToNoiseRatio = norm(z*z','fro')^2/norm(c_noise/2.*(N + N'),'fro')^2;
    avg_signalToNoiseRatio = avg_signalToNoiseRatio + signalToNoiseRatio/numExp;
   
    
    % EXTRA-GRADIENT
    
    [U,S] = eigs(M,rSVD,'largestreal'); %low rank approximation
    X = U*U';
    X_initial = X;
    
    Y = sign(X);
    
    X_dualGapMin = X;
    Y_dualGapMin = Y;
    
    errorInitial_LR = norm(X-z*z','fro')^2 / norm(z*z','fro')^2;
    avg_errorInitial_LR = avg_errorInitial_LR + errorInitial_LR ./ numExp;
    
    Xinitial_norm1 = sum(sum(abs(X)));
    avg_XinitialNorm1 = avg_XinitialNorm1 + Xinitial_norm1/numExp;
    
    [U2,S2] = eigs(lambda*Y-M,1,'smallestreal');
    dual_gapX_dualGapMin = trace((X-(U2(:,1)*U2(:,1)'))'*(lambda*Y-M));
    dual_gapY_dualGapMin = trace((Y-sign(lambda*X))'*(lambda*X));
    minDualGap = dual_gapX_dualGapMin - dual_gapY_dualGapMin;
    
    checkCondition_Z = zeros(T,1);
    checkCondition_X = zeros(T,1); 
    Z_ergodic = zeros(n);
    W_ergodic = zeros(n);
   
    
    for t = 1:T
        
        grad_X = -M+lambda*Y;
        [U,S] = eigs(X-eta*grad_X,rSVD+1,'largestreal');
        eigens = projsplx(diag(S(1:rSVD,1:rSVD)),1);
        Z = U(:,1:rSVD)*diag(eigens)*U(:,1:rSVD)';
        
        if sum(diag(S(1:rSVD,1:rSVD))) >= 1+rSVD*S(rSVD+1,rSVD+1)
            checkCondition_Z(t) = 1;
        end
        
        Z_ergodic = Z_ergodic + Z/T;
        
        grad_Y = lambda*X;
        W = Y + eta*grad_Y;
        W(W>1) = 1;     
        W(W<-1) = -1;
        
        W_ergodic = W_ergodic + W/T;
        
        grad_Z = -M+lambda*W;
        [U,S] = eigs(X-eta*grad_Z,rSVD+1,'largestreal');
        eigens = projsplx(diag(S(1:rSVD,1:rSVD)),1);
        X = U(:,1:rSVD)*diag(eigens)*U(:,1:rSVD)';
        
        if sum(diag(S(1:rSVD,1:rSVD))) >= 1+rSVD*S(rSVD+1,rSVD+1)
            checkCondition_X(t) = 1;
        end
        
        grad_W = lambda*Z;
        Y = Y + eta*grad_W;
        Y(Y>1) = 1;     
        Y(Y<-1) = -1;
        
        [U2,S2] = eigs(lambda*Y-M,1,'smallestreal');
        dual_gapX_dualGapMin = trace((X-(U2(:,1)*U2(:,1)'))'*(lambda*Y-M));
        dual_gapY_dualGapMin = trace((Y-sign(lambda*X))'*(lambda*X));
        dual_gap_dualGapMin = dual_gapX_dualGapMin - dual_gapY_dualGapMin;
        if dual_gap_dualGapMin < minDualGap
            minDualGap = dual_gap_dualGapMin;
            X_dualGapMin = X;
            Y_dualGapMin = Y;
        end
        
        [U2,S2] = eigs(lambda*W-M,1,'smallestreal');
        dual_gapX_dualGapMin = trace((Z-(U2(:,1)*U2(:,1)'))'*(lambda*W-M));
        dual_gapY_dualGapMin = trace((W-sign(lambda*Z))'*(lambda*Z));
        dual_gap_dualGapMin = dual_gapX_dualGapMin - dual_gapY_dualGapMin;
        if dual_gap_dualGapMin < minDualGap
            minDualGap = dual_gap_dualGapMin;
            X_dualGapMin = Z;
            Y_dualGapMin = W;
        end
        
    end
        

    avg_minDualGap = avg_minDualGap + minDualGap/numExp;
    
    error_dualGapMin = norm(X_dualGapMin-z*z','fro')^2 / norm(z*z','fro')^2;
    avg_error_dualGapMin = avg_error_dualGapMin + error_dualGapMin ./ numExp;
    
    X_norm1_dualGapMin = sum(sum(abs(X_dualGapMin)));
    avg_Xnorm1_dualGapMin = avg_Xnorm1_dualGapMin + X_norm1_dualGapMin/numExp;
    
    [U4,S4] = eigs(-(-M+lambda*Y_dualGapMin),rSVD+1,'largestreal');
    gap_dualGapMin = S4(rSVD,rSVD) - S4(rSVD+1,rSVD+1);
    avg_gap_dualGapMin = avg_gap_dualGapMin + gap_dualGapMin ./ numExp;
    
    numIterCondHolds_Z = nnz(checkCondition_Z);
    avg_numIterCondHolds_Z = avg_numIterCondHolds_Z + numIterCondHolds_Z ./ numExp;
    firstIterConditionHolds_Z = find(checkCondition_Z,1,'first');
    avg_firstIterConditionHolds_Z = avg_firstIterConditionHolds_Z +firstIterConditionHolds_Z/numExp;
    
    numIterCondHolds_X = nnz(checkCondition_X);
    avg_numIterCondHolds_X = avg_numIterCondHolds_X + numIterCondHolds_X ./ numExp;
    firstIterConditionHolds_X = find(checkCondition_X,1,'first');
    avg_firstIterConditionHolds_X = avg_firstIterConditionHolds_X +firstIterConditionHolds_X/numExp;
    
    X_norm1_ergodic = sum(sum(abs(Z_ergodic)));
    avg_Xnorm1_ergodic = avg_Xnorm1_ergodic + X_norm1_ergodic/numExp;
    

    
    error_ergodic = norm(Z_ergodic-z*z','fro')^2 / norm(z*z','fro')^2;
    avg_error_ergodic = avg_error_ergodic + error_ergodic ./ numExp;

    
    rank_ergodic = rank(Z_ergodic);
    avg_rank_ergodic = avg_rank_ergodic + rank_ergodic ./ numExp;
    
    [U1,S1] = eigs(-(-M+lambda*W_ergodic),rSVD+1,'largestreal');
    gap = S1(rSVD,rSVD) - S1(rSVD+1,rSVD+1);
    avg_gap = avg_gap + gap ./ numExp;
    
    dual_gapX_ergodic = trace((Z_ergodic-(U1(:,1)*U1(:,1)'))'*(-M+lambda*W_ergodic));
    dual_gapY_ergodic = trace((W_ergodic-sign(lambda*Z_ergodic))'*(lambda*Z_ergodic));
    dual_gap_ergodic = dual_gapX_ergodic - dual_gapY_ergodic;
    avg_dual_gap_ergodic = avg_dual_gap_ergodic + dual_gap_ergodic/numExp;


end 

avg_signalToNoiseRatio
avg_c_noise
avg_errorInitial_LR
avg_numIterCondHolds_Z
avg_firstIterConditionHolds_Z
avg_numIterCondHolds_X
avg_firstIterConditionHolds_X
avg_minDualGap
avg_error_dualGapMin
avg_gap_dualGapMin