source("R/pretraining/bacteria/train.R")
source("R/pretraining/bacteria/context.R")
source("R/pretraining/bacteria/encoder.R")
source("R/pretraining/bacteria/loss_functionSG.R")
train_data_folder <- "data/bacteria/train"
validation_data_folder <- "data/bacteria/validation"
tensorboard_folder <- "tensorboard"

train_Self_GenomeNet(
  path            = train_data_folder,
  path.val        = validation_data_folder,
  maxlen          = 1000,
  encoder         = encoder_bacteria_pretraining(1000),
  context         = context_bacteria_pretraining,
  loss_function   = loss_functionSG,
  batch.size      = 2,#128,
  epochs          = 5,#1000,
  steps.per.epoch = 10,#,400,
  learningrate    = 0.0001,
  run.name        = paste("Self-GenomeNet", format(Sys.time(), "_%y%m%d_%H%M"), sep = ""),
  tensorboard.log = tensorboard_folder,
  trained_model   = NULL,
  savemodels      = TRUE,
  save_every_xth_epoch = 5,#100,
  proportion_per_file = 0.1
)
