output_dir=/opt/nvme1/<user-name>/projects/world-model-RL-store/SSR/outputs
model_identifier=first_try

config_path=projects/configs/SSR/SSR_e2e_enable_rl.py

# train the model
python -m torch.distributed.run \
--nproc_per_node=8 \
--master_port=23349 \
tools/train.py \
"${config_path}" \
--launcher pytorch \
--deterministic \
--work-dir "${output_dir}/${model_identifier}"

sleep 10

# test the model
CUDA_VISIBLE_DEVICES=1 python tools/test.py "${config_path}" \
"${output_dir}/${model_identifier}/epoch_12_ema.pth" \
--launcher none \
--eval bbox \
--tmpdir tmp \
--out "${output_dir}/${model_identifier}/result.pkl"