import os

def delete_files_with_digit_suffix():
    # Get the list of all files in the current directory
    files = [f for f in os.listdir('.') if os.path.isfile(f)]
    
    for file in files:
        # Split the file name and extension
        #name, ext = os.path.splitext(file)
        
        # Check if the last character of the name is a digit between 1 and 9
        if  file[-1].isdigit():
            try:
                # Delete the file
                os.remove(file)
                print(f"Deleted file: {file}")
            except Exception as e:
                print(f"Error deleting file {file}: {e}")

if __name__ == "__main__":
    delete_files_with_digit_suffix()

