#!/bin/bash

# Grid Engine options (lines prefixed with #$)
# Runtime limit of 10 hour:
#$ -l h_rt=05:00:00
#
# Set working directory to the directory where the job is submitted from:
#$ -cwd
#
# Request one GPU in the gpu queue:
#$ -q gpu 
#$ -pe gpu-a100 1
#
# Request 4 GB system RAM 
# the total system RAM available to the job is the value specified here multiplied by 
# the number of requested GPUs (above)
#$ -l h_vmem=175G

# Initialise the environment modules and load CUDA version 11.0.2
. /etc/profile.d/modules.sh
module load cuda
#module load cuda/12.1.1
module load anaconda 
conda config --add envs_dirs /exports/eddie/scratch/s2593541/anaconda/envs
conda config --add pkgs_dirs /exports/eddie/scratch/s2593541/anaconda/pkgs
conda activate lrd3_new
nvidia-smi

export HF_DATASETS_CACHE="/exports/eddie/scratch/s2593541/cache/lm_eval"
export TOKENIZERS_PARALLELISM=false

#MODEL=meta-llama/Llama-2-13b-hf
#MODEL=google/gemma-2b
MODEL=meta-llama/Llama-2-7b-hf
CACHE_DIR=/exports/eddie/scratch/s2593541/lrd/cache_train_llama4/
BS=8

MODEL=google/gemma-7b
CACHE_DIR=/exports/eddie/scratch/s2593541/lrd/cache_train_gemma/
BS=8
#MODEL=baffo32/decapoda-research-llama-7B-hf
#CACHE_DIR=/exports/eddie/scratch/s2593541/lrd/cache_train_llama_dc

#MODEL=meta-llama/Meta-Llama-3-8B
#CACHE_DIR=/exports/eddie/scratch/s2593541/lrd/cache_train_llama/

#MODEL=meta-llama/Meta-Llama-3-8B

#EXP_NAME="${MODEL#*/}_svd_90"
#python evaluate_naive_svd.py --model_name=$MODEL --param_ratio=0.90 --cache_dir=$CACHE_DIR --exp_name=$EXP_NAME  --act_aware="" --batch_size=$BS

#EXP_NAME="${MODEL#*/}_baseline"
#python evaluate_naive_svd.py --model_name=$MODEL --ignore_compression --cache_dir=$CACHE_DIR --exp_name=$EXP_NAME  --act_aware="" --batch_size=$BS

for PARAM_RATIO in 0.9 0.85 0.80
do
    EXP_NAME="${MODEL#*/}_asvd_${PARAM_RATIO//./}"  # Remove the decimal point from PARAM_RATIO for EXP_NAME
    python evaluate_naive_svd.py --model_name=$MODEL --cache_dir=$CACHE_DIR --alpha=0.5 --exp_name=$EXP_NAME --param_ratio=$PARAM_RATIO --act_aware=activation --batch_size=$BS --load_act_cache
done


#EXP_NAME=baseline_naive_asvd_0_85
#RATIO=0.85
#python evaluate_naive_svd.py --model_name=meta-llama/Llama-2-7b-hf --cache_dir=/exports/eddie/scratch/s2593541/lrd/cache_train_llama3 --exp_name=$EXP_NAME --param_ratio=$RATIO --act_aware=activation --batch_size=16 --load_act_cache

#EXP_NAME=llama_8bit
#python evaluate_naive_svd.py --use_int8 --model_name=meta-llama/Llama-2-7b-hf --ignore_compression --cache_dir=/exports/eddie/scratch/s2593541/lrd/cache_train_llama3 --exp_name=$EXP_NAME --param_ratio=-1 --batch_size=16

#EXP_NAME=baseline_naive_asvd_0_80
#RATIO=0.80
#python evaluate_naive_svd.py --model_name=meta-llama/Llama-2-7b-hf --ignore_compression --cache_dir=/exports/eddie/scratch/s2593541/lrd/cache_train_llama3 --exp_name=$EXP_NAME --param_ratio=$RATIO --act_aware=activation --batch_size=8 --load_act_cache

#EXP_NAME=baseline_naive_asvd_0_85
