# SemiCLIP

This is PyTorch implementation of Semi-Supervised CLIP Training by Enforcing Semantic and Trapezoidal Consistency submitted to ICLR 2025. 

## Dataset

The directory structure for datasets looks like:

```
Path/To/Dataset
├─ aerial
│  ├─ RSICD
|  ├─ UCM_captions
|  ├─ Sydney_captions
│  ├─......
├─ fashion
│  ├─ fashion200k
│  ├─ FashionGen
│  └─ PolyvoreOutfits
└─ ......
```

## Usage

Train our proposed SemiCLIP for different settings.

For remote sensing datasets

```
# For supervised pre-training
torchrun --nproc_per_node 4 -m main --model "ViT-B-16" --pretrained openai --train-data "RS-ALL" --data-dir "Path/To/Dataset" --label-ratio "0.1" --val-data "RS-ALL" --imagenet-val "RSICD-CLS" --keyword-path "keywords/RS/class-name.txt" --lr 5e-5 --batch-size 64 --warmup 10 --zeroshot-frequency 5 --precision amp --method "semiclip" --seed "0" --stage 1 --epochs 25 --save_ckpt --pkname "stage1/semiclip_seed0" --pratio 0.3 --logs "../results/sclip_log/semiclip_stage1_seed0/"

# For semi-supervised fine-tuning
torchrun --nproc_per_node 4 -m main --model "ViT-B-16" --pretrained openai --train-data "RS-ALL" --data-dir "Path/To/Dataset" --label-ratio "0.1" --val-data "RS-ALL" --imagenet-val "RSICD-CLS" --keyword-path "keywords/RS/class-name.txt" --lr 5e-5 --batch-size 64 --warmup 10 --zeroshot-frequency 5 --precision amp --method "semiclip" --seed "0" --stage 2 --epochs 15 --pkname "stage1/semiclip_seed0" --pratio 0.3 --save_ckpt --logs "../results/sclip_log/semiclip_stage2_seed0/" --resume-path "../results/sclip_log/semiclip_stage1_seed0/checkpoints"

```



For fashion datasets:

```
# For supervised pre-training
torchrun --nproc_per_node 4 -m main --model "ViT-B-16" --pretrained openai --train-data "Fashion-AL" --data-dir "Path/To/Dataset" --label-ratio "0.1" --val-data "Fashion200k" --imagenet-val "Fashion200k-CLS" --keyword-path "keywords/RS/class-name.txt" --lr 5e-5 --batch-size 64 --warmup 10 --zeroshot-frequency 5 --precision amp --method "semiclip" --seed "0" --stage 1 --epochs 25 --save_ckpt --pkname "stage1/semiclip_seed0" --pratio 0.3 --logs "../results/sclip_log/semiclip_stage1_seed0/"

# For semi-supervised fine-tuning
torchrun --nproc_per_node 4 -m main --model "ViT-B-16" --pretrained openai --train-data "RS-ALL" --data-dir "Path/To/Dataset" --label-ratio "0.1" --val-data "RS-ALL" --imagenet-val "RSICD-CLS" --keyword-path "keywords/RS/class-name.txt" --lr 5e-5 --batch-size 64 --warmup 10 --zeroshot-frequency 5 --precision amp --method "semiclip" --seed "0" --stage 2 --epochs 15 --pkname "stage1/semiclip_seed0" --pratio 0.3 --save_ckpt --logs "../results/sclip_log/semiclip_stage2_seed0/" --resume-path "../results/sclip_log/semiclip_stage1_seed0/checkpoints"

```