#!/bin/bash
#SBATCH --job-name=test_protonet_meta_dataset
#SBATCH --output=../logs/test_protonet_meta_dataset_%a.out
#SBATCH --error=../logs/test_protonet_meta_dataset_%a.err
#SBATCH --gres=gpu:1
#SBATCH --cpus-per-task=2
#SBATCH --mem=10G
#SBATCH --array=0-5

source ../env/bin/activate
ulimit -n 50000

# Overwrite PATH_TO_RECORDS
mkdir -p $PATH_TO_RECORDS
cp -r $PATH_TO_RECORDS $SLURM_TMPDIR

echo "Finished moving data"
cd ..
python -m src.main --exp_name test_protonet_meta_dataset --log-test-tasks --model protonet --runs 1 --folder $SLURM_TMPDIR/records --meta-lr 0.001 --task_sampler $SLURM_ARRAY_TASK_ID --dataset meta_dataset --num-ways 5 --num-shots 1 --use-cuda --step-size 0.4 --batch-size 1 --num-workers 0 --num-epochs 100 --output-folder ./config/protonet_meta_dataset/$SLURM_ARRAY_TASK_ID/

rm -rf $SLURM_TMPDIR/records
