# !/bin/bash
set -x

temp=${1:-1.0}
bsz=${2:-32}

for k in 1 2 3 4 5 6 7 8
do
    torchrun \
    --nnodes=1 --nproc_per_node=8 --node_rank=0 \
    --master_port=12346 \
    autoregressive/sample/sample_t2i_ddp_hf_prob.py \
    --gpt-ckpt ./LlamaGen-T2I-2 \
    --vq-ckpt ./LlamaGen-T2I/vq_ds16_t2i.pt \
    --image-size 512
    --temperature $temp \
    --batch_size $bsz
done
python3 evaluations/t2i/evaluation.py \
--eval_res 256 \
--how_many 30000 \
--ref_data coco2014 \
--ref_type val2014 \
--batch_size 256 \
--ref_dir ./coco \
--fake_dir "samples_coco/LlamaGen-T2I-2-mscoco_text_features-size-512-size-512-VQ-16-topk-1000-topp-1.0-temperature-${temp}-cfg-7.5-seed-0"