# !/bin/bash
set -x
for i in 0.0001 0.00001 0.000001
do
    for j in 100 10
    do
        for k in 1 2 3 4 5 6 7 8
        do
            torchrun \
            --nnodes=1 --nproc_per_node=8 --node_rank=0 \
            --master_port=12346 \
            autoregressive/sample/sample_t2i_ddp_eagle_relaxed_hf.py \
            --gpt-ckpt ./eagle_t2i \
            --vq-ckpt ./LlamaGen-T2I/vq_ds16_t2i.pt \
            --gpt-base-ckpt ./LlamaGen-T2I \
            --adaptive-func "jsd" \
            --prompt-csv ./mscoco_text_features \
            --coeff-a $i \
            --coeff-b $j
        done
        python3 evaluations/t2i/evaluation.py \
        --eval_res 256 \ 
        --batch_size 256 \
        --how_many 30000 \
        --ref_data coco2014 \
        --ref_type val2014 \
        --eval_res 256 \
        --batch_size 256 \
        --ref_dir ./coco \
        --fake_dir "samples_coco/eagle_t2i-mscoco_text_features-size-256-size-256-VQ-16-topk-1000-topp-1.0-temperature-1.0-cfg-7.5-seed-0-warmup-0-adative-jsd-a-${i}-b-${j}.0"
        python3 accepted_length.py\
        --path "samples_coco/eagle_t2i-mscoco_text_features-size-256-size-256-VQ-16-topk-1000-topp-1.0-temperature-1.0-cfg-7.5-seed-0-warmup-0-adative-jsd-a-${i}-b-${j}.0"
    done
done
