# LANTERN
## Model conversion

```
LANTERN/LlamaGen/autoregressive/models/test_model.ipynb
```

## Drafter training
1. Install dependency in EAGLE directory

``` 
pip install -r requirements.txt
```

2. Download subset of LAION-COCO dataset

3. Data generation
``` 
python -m eagle.ge_data.allocation_t2i.py --outdir [path to data]
```

4. Training
``` accelerate launch -m --mixed_precision=bf16 eagle.train.main_llamagen_t2i --tmpdir [path to data] --cpdir [path to checkpoints] --configpath [path to config file] 
```

## Inference

```
pip install numpy
pip install scipy
pip install tqdm
pip install transformers
pip install pandas
pip install jsonlines
pip install -U "huggingface_hub[cli]"
pip install git+https://github.com/openai/CLIP.git
pip install open_clip_torch
pip install clean_fid
cd LANTERN/LlamaGen
mkdir coco
cd coco
wget http://images.cocodataset.org/zips/val2014.zip
unzip val2014.zip
cd ..
tar -xvf mscoco_text_features.tar

bash scripts/autoregressive/sample_t2i_ours_hf_single.sh 0.4 1000 0
```

## Reference

Our code was written based on EAGLE and LlamaGen official implementaion.