### How to reproduce the RoboSumo Ants experiment

#### Dependencies

- `RoboSumo`: the modified version is under the `robosumo/` directory. Original repo by openai. Please check its README for more info.

- openai/`mujoco-py` and `mujoco` binaries

- openai/`gym`



#### Step 1: Pretrain some agents

For example, in directory `sumo/`, run

```bash
python collect_expert_data.py --policy-names lstm lstm --param-versions 1 1 --save data
python pretrain.py lstm0 x pretrain/pretrainx0
python pretrain.py lstm0 y pretrain/pretrainy0
```



#### Step 2: Self-play

Bash commands to train the baseline self-play methods:

```bash
# baseline self-play (latest)
python train.py --env sumo --gamma 0.995 --test_gamma 1.0 --gae_lambda 0.97 --opt rmsprop --lr 3e-5 --value_lr_mult 10 --method base --nagent 1 --save result/sumo/base/ --max_grad_norm 0.1 --entropy_coef 0 --T 100 --batch 500 --test_T 100 --test_batch 500 --niter 50 --ninner 10 --algo ppo --minibatch_size 512 --opt_epochs 3 --clip 0.2 --sep_opt --anneal_lr --nproc 20

# baseline self-play (random past)
python train.py --env sumo --gamma 0.995 --test_gamma 1.0 --gae_lambda 0.98 --opt rmsprop --lr 3e-5 --value_lr_mult 30 --method baserand --nagent 1 --save result/sumo/baserand/0 --max_grad_norm 0.1 --entropy_coef 0 --T 100 --batch 500 --test_T 100 --test_batch 500 --niter 50 --ninner 9 --algo ppo --minibatch_size 512 --opt_epochs 3 --clip 0.2 --sep_opt --anneal_lr --nproc 25

# baseline self-play (best past)
python train.py --env sumo --gamma 0.995 --test_gamma 1.0 --gae_lambda 0.98 --opt rmsprop --lr 3e-5 --value_lr_mult 30 --method basebest --nagent 1 --save result/sumo/basebest/0 --max_grad_norm 0.1 --entropy_coef 0 --T 100 --batch 500 --test_T 100 --test_batch 500 --niter 50 --ninner 9 --algo ppo --minibatch_size 512 --opt_epochs 3 --clip 0.2 --sep_opt --anneal_lr --nproc 25
```

Bash commands to train `Ours(8)`:

```bash
python train.py --env sumo --gamma 0.995 --test_gamma 0.995 --gae_lambda 0.98 --opt rmsprop --lr 3e-5 --value_lr_mult 30 --method constv --nagent 8 --save result/sumo/constv8/0 --max_grad_norm 0.1 --entropy_coef 0 --T 100 --batch 500 --test_T 100 --test_batch 500 --niter 50 --ninner 9 --algo ppo --minibatch_size 512 --opt_epochs 3 --clip 0.2 --sep_opt --anneal_lr --nproc 30 --c_adalr --target_gap 0.01 --delta 0.01
```



#### Step 3: Evaluate through a tournament

```bash
python tour.py --nproc 30 --b 100 --env sumo --config sumo_v --gamma 1 --save tour/sumo_n4_b100_slow.pkl
```

This will also compute the Elo scores.