# FCQ
Finegrained Controllable Quantization 


# Pipeline
All programs need to be in the **./detr** folder path.

## QAT    
### 1. HAWQ_Detr(basic quantization)
default-parameter (No modification is required generally): 

```
    --lr 1e-5 \
    --backbone resnet50 \
```

If you want to quantize detr(entire model: backbone + input-proj + decoder + encoder) with HAWQ in uniform 8bit-weight-float-activation type, you can choose args : ``` --quant-scheme detr8w0a \ ```.
For example :
```
    --quant-scheme detr8w0a \
    --quant-backbone \
    --quant-input-proj \
    --quant-decoder \
    --quant-encoder \
```

If you want to use ILP_quant_type(bit_min: 3; bit_max: 6; averaged_bit: 4; float_activation), you can modify args : ``` --quant-scheme ILP_3_6_4_ActFull \ ``` and add args : ``` --ILP the path of ILP_json \ ```.
For example :
```
    --quant-scheme ILP_3_6_4_ActFull \
    --ILP "../bit_config/mix_grad_norm_ILP/detr/resnet50/full+sp1_gn/ILP_3_6_4.json" \
    --quant-backbone \
    --quant-input-proj \
    --quant-decoder \
    --quant-encoder \
```

### 2. QAT + distillation
If you want to use QAT, you can use HAWQ_Detr configuration above.
If you want to add distillation, you can add args : ``` --teacher \ ```

### 3. using detr-single-super-class-loss as criterion_reg
When you want to use single_super_class_loss as criterion_reg in QAT, you can add args : 

*(Detr_super_class_id: 1 - 12   ||   Segm_super_class_id: 1 - 27)*
```
    --qat_sp "../FCQ/detr/super_category_id/detr/{super_class_id}.json" \
```

When you want to use single_super_class_loss as criterion in PTQ, you can 
```
    --super_category "../FCQ/detr/super_category_id/detr/{super_class_id}.json" \
```

### 4. QAT-finegrained: ori_loss + single_sp_loss + regular
#### (1) Detr  model
Backbone supported : resnet50 || resnet101

You can modify ``` --backbone resnet101 \ ``` to choose resnet101 as backbone.

Configuration related to regularization: ``` --grad_L2: regular parameter \ ```


**The complete script run example** is as follows : 

```
CUDA_VISIBLE_DEVICES=0,1,2,3 python -m torch.distributed.launch --nproc_per_node=4 --use_env main.py \
            --fix-BN \
            --batch_size 2 \
            --epochs 50 \
            --output_dir './result/detr_resnet50' \
            --coco_path /path/to/coco \
            --resume /path/to/pretrained/detr-r50-e632da11.pth \
            --quant-scheme ILP_3_6_4_ActFull \
            --ILP "/path/to/ILP_3_6_4.json" \
            --quant-backbone \
            --quant-input-proj \
            --quant-decoder \
            --quant-encoder \
            --teacher \
            --qat_sp "/path/to/super_category_id/detr/1.json" \
            --grad_L2 1e-3 \
```

#### (2) Segmentation model
Backbone supported : resnet50 || resnet101

Segm-QAT-finegrained :

We train detr part model in segmentation model first, and then add downstream tasks : **segm_head**

***First step :***

Training the detr_part in segmentation model.

( preparation work: need to prepare segm-detr_patr-pretrain_model for args.resume )

**need to add arguments in above complete Shell Config :**
```
    --lr_drop 15 \
    --dataset_file coco_panoptic \
    --coco_panoptic_path /path/to/dataset/panoptic_annotations_trainval2017/ \
```


**The complete script run example** is as follows : 

```
CUDA_VISIBLE_DEVICES=0,1,2,3 python -m torch.distributed.launch --nproc_per_node=4 --use_env main.py \
            --fix-BN \
            --lr_drop 15 \
            --dataset_file coco_panoptic \
            --coco_panoptic_path /path/to/dataset/panoptic_annotations_trainval2017/ \
            --batch_size 1 \
            --epochs 50 \
            --output_dir './result/test_segm' \
            --coco_path /path/to/dataset/COCO_2017/ \
            --resume /path/to/pretrained/segm-detr-part.pth \
            --quant-scheme ILP_3_6_4_ActFull \
            --ILP "/path/to/ILP_3_6_4.json" \
            --quant-backbone \
            --quant-input-proj \
            --quant-decoder \
            --quant-encoder \
            --teacher \
            --qat_sp "/path/to/super_category_id/segm/1.json" \
            --grad_L2 1e-3 \
```

if you want to train whole segmentation model(detr + segm_head), you need to add args. just as mentioned above.

```
    --masks \
    ----frozen_weights /path/to/pretrained/detr-r50-panoptic-00ce5173.pth \
```

