import gymnasium as gym

# Create Acrobot environment
env = gym.make('Acrobot-v1')

# Print action and observation space
print('Action space:', env.action_space)
print('Observation space:', env.observation_space)

# Run it for 1000 time steps
obs = env.reset()
done = False
for t in range(1000000):

    action = env.action_space.sample()
    obs, reward, done, _, _ = env.step(action)

    if done:

        print('Episode finished after {} timesteps'.format(t+1))
        print('Done: ', done)
        print('Final reward: ', reward)

        break
