# SST-2 / sst-5 / mr / cr / mpqa / subj / trec / CoLA / MNLI / SNLI / QNLI / RTE / MRPC / QQP / STS-B
modelbase='roberta-base';
seed=0;
K=8;
sparsitylevel=1e-5 ;
lr=1e7 ;
no_train=False; 
ckpt_lr=2e-5;

# mask_path: gamma_base
# checkpoint_location: S
TASK_LIST=("SST-2" "cr" "mr" "mpqa" "trec" "subj" "QNLI" "SNLI" "MNLI" "RTE" "MRPC" "QQP");
# TASK_LIST=("trec" "subj" "QNLI" "SNLI" "MNLI" "RTE" "MRPC" "QQP" "SST-2" "cr" "mr" "mpqa");
# TASK_LIST=("mr" "mpqa" "trec" "subj" "QNLI" "SNLI" "MNLI" "RTE" "MRPC" "QQP");
# TASK_LIST=("mr");
# TASK_LIST=("QNLI" "MNLI");
# TASK_LIST=("QNLI");
mask_path="highest_movement"


for TASK in ${TASK_LIST[@]}; do
    model_path="/data/common/lm-bff/ckpt_paths/log_noembed_SGD_graft/$TASK-prompt-64-0-roberta-base-2-$ckpt_lr" \
    checkpoint_location="/data/common/lm-bff/mask_path/temp/S_$TASK-prompt-64-0-roberta-base-2-$ckpt_lr" \
    TAG=exp \
    TYPE=prompt \
    TASK=$TASK \
    K=$K \
    LR=$lr \
    SEED=$seed \
    MODEL=$model_path \
    uselmhead=1 \
    useCLS=0\
    num_train_epochs=20 \
    mask_path=$mask_path \
    sparsitylevel=$sparsitylevel \
    pretrained_model=$modelbase \
    fixhead=True \
    fixembeddings=True \
    truncate_head=True\
    train_bias_only=False \
    no_train=$no_train \
    checkpoint_location=$checkpoint_location\
    bash scripts/run_graft_experiment.sh;
done
