from rl import mountaincar
from rl import offline


def get_config():
    config = dict(
        dataset_file="./mc_data_eps_00.npz",
        compress=True,
        mc_config=dict(
            seed=42,
            min_pos=-1.2,
            max_pos=0.6,
            min_init_pos=-0.6,
            max_init_pos=-0.4,
            max_speed=0.07,
            goal_pos=0.5,
            force=0.001,
            gravity=0.0025,
        ),
        policy_config=dict(
            epsilon=0,
        ),
        rollout_config=dict(
            seed=13,
            num_trajs=1000,
            max_steps_per_traj=300,
        ),

    )
    return config


def main():
    config = get_config()
    dataset = offline.generate_dataset(
        env=mountaincar.MountainCar(**config["mc_config"]),
        policy=mountaincar.MountainCarPolicy(**config["policy_config"]),
        **config["rollout_config"],
    )
    dataset.save(config["dataset_file"], config["compress"])
    print(f"Generated {dataset.num_samples()} sample transitions.")
    
    offline.Dataset.load(config["dataset_file"])


if __name__ == "__main__":
    main()
