#!/bin/bash

START_DAY=$(date +"%F")
START_TIME=$(date +"%H-%M-%S-%N")

CHECKPOINT_ROOT=~/frm_rl/checkpoints
CHECKPOINT_DIR="$CHECKPOINT_ROOT/$START_DAY/$START_TIME"
mkdir -p $CHECKPOINT_DIR


function cleanup {
	# attempt to clean up checkpoint dir if empty
	rmdir --ignore-fail-on-non-empty $CHECKPOINT_DIR "$CHECKPOINT_ROOT/$START_DAY"
}
trap cleanup EXIT


BATCH_SIZE=2048
TRAIN_STEPS=4000

if [[ -v FRM_DEBUG ]]; then
	echo "Running with python debugger"
	python -m pdb -c "c" rl/main_loop.py --experiment_mode='train' --dataset=./mc_data.npz --batch_size=$BATCH_SIZE --checkpoint_root="$CHECKPOINT_DIR" --train_steps=$TRAIN_STEPS
else
	python rl/main_loop.py --experiment_mode='train' --dataset=./mc_data.npz --batch_size=$BATCH_SIZE --checkpoint_root="$CHECKPOINT_DIR" --train_steps=$TRAIN_STEPS
fi
