from typing import List, Dict, Optional
from pydantic import BaseModel
import json
from models.entity import Entity
from models.relationship import Relationship
from openai import OpenAI
import os
from query.base import Base
from utils.rag import search_docs#, get_data

class Rag(Base):
    def __init__(self, max_hops: int = 2, min_confidence: float = 0.7, **kwargs):
        super().__init__(**kwargs)
        self.max_hops = max_hops
        self.min_confidence = min_confidence
        # self.prompt = RAG_PROMPT

    def process_query(self, user_query: str, today_date: str):
        """Base method for processing queries"""
        raise NotImplementedError("Subclasses must implement process_query")

    def build_node_context(
        self,
        node,
        start_date,
        time_range,
        abnormality = None
    ):
        context =''
        data = {}
        if self.dataset_name in node.dataSource:
            sensor_specific_info = f"1.description: {node.dataSource[self.dataset_name]['description']}\n"
            sensor_specific_info += f"2.range: {node.dataSource[self.dataset_name]['range']}\n"
            sensor_specific_info += f"3.unit: {node.dataSource[self.dataset_name]['unit']}\n"
            context +=(f"{node.name}:\n"
                    f"description: {node.description}\n"
                    f"range: {node.range}\n"
                    f"recommendation: {node.recommendation}\n"
                    f"sensor specific information: \n{sensor_specific_info}"
                )
            context += 'Data:\n'
            node_name = node.name
                # df = self.get_data(data_root_path,path, start_date, end_date,[id])
            df = self.get_data(self.par_df.copy(),start_date, time_range,node_name)
            mark_data = df.to_markdown(index=False)
            trace = {
            "x": df['date'].tolist(),
            "y": df[node_name].tolist(),
            }
            data[node_name] = trace
            context += (
                f"{mark_data}\n"
            )
            if abnormality is not None:
                context += f"Abnormality of recent {time_range} days compared to individual's average: {abnormality}\n"
                # context += f"Recent Abnormality: {recent_abnormality}\n"
            else:
                context += f"Abnormality of recent {time_range} days compared to individual's average: No abnormality level\n"
        else:
            context += (
                f"data: No data\n"
            )
     
        return context, data
