import logging
import json
logger = logging.getLogger(__name__)
from typing import List, Dict, Optional
def parse_llm_response(response: str) -> Optional[List[Dict]]:
    """
    Parse the LLM response that contains JSON data.
    
    Args:
        response: Raw response string from LLM containing JSON
        
    Returns:
        Parsed JSON data as a list of dictionaries, or None if parsing fails
    """
    try:
        # Extract JSON content between triple backticks if present
        if "```json" in response:
            json_content = response.split("```json")[1].split("```")[0].strip()
        else:
            json_content = response.strip()
        # print(json_content)
        json_content = json_content.replace("None", "null")
        # Parse the JSON content
        output_llm = json.loads(json_content)

        return output_llm
        
    except json.JSONDecodeError as e:
        logger.error(f"Failed to parse JSON response: {str(e)}")

        # logger.error(f"Raw response: {response}")
        return None
    except Exception as e:
        logger.error(f"Unexpected error parsing response: {str(e)}")
        return None
    
def parse_search_results(res,short_answer_only=False):
    short_answer = ''
    if 'answerBox' in res:
        short_answer = res['answerBox']['snippet']
        #short_answer = res['answerBox']['snippetHighlighted']
    reference = ""
    for id, item in enumerate(res['organic']):
        try:
            reference += f"Reference {id}: {item['snippet']}\n"
        except KeyError:
            print(f"KeyError: {item}")
            continue
    if short_answer_only:
        if short_answer =='':
            return reference
        else:
            return short_answer
    else:
        return f"{short_answer}\n{reference}"