import numpy as np





def Khatri_Rao_np(A,B):
  """
  Parameters: 
    A: matrix (numpy array)
    B: matrix (numpy array)
  Returns:
    KR: Khatri-Rao product of the two matrices
  """
  lis=[]#in this list we will append all the khatri rao products of columns of A and columns of B

  #TODO: make sure these are high precision floats

  #for every column pair (a,b)

  for i in range(B.shape[1]):
    a=A[:,i]#ith column of A
    b=B[:,i]#ith column of B
    krab=np.matmul(a.reshape(a.shape[0],1), b.reshape(1,b.shape[0]))
    size=a.shape[0]*b.shape[0]  
    krab=krab.reshape(size)
    lis.append(krab)

  KR=np.stack(lis, axis=1)

  return KR  


def to_flat_tensor_np(X,Y,Z):
  """
  Returns the flattened version of the tensor obtained by the Khatri-Rao product of A,B,C
  """
  YodotZ=Khatri_Rao_np(Y,Z)
  T_flat=X@YodotZ.T
  return T_flat



def objective_function_np(X,Y,Z,T_flat):
  Model_flat=to_flat_tensor_np(X,Y,Z)
  D=Model_flat-T_flat
  # return  np.sum(D*D) 
  return np.linalg.norm(D, ord='fro')




def Gaussian_np(k=4, n=6, sigma=1):
  """
  Returns a tuple (X,Y,Z) of order 2 (matrices) that are intialized by independent random Gaussians with mean 0 and variance 1
  """
  Gaussians=[0,0,0]
  Matrices=[0,0,0]
  for i in range(3):
    Gaussians[i]=[[np.random.normal(0,sigma) for _ in range(k)] for _ in range(n)]
    Matrices[i]=np.array(Gaussians[i])
  return (Matrices[0], Matrices[1], Matrices[2])

